/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.SlimClient;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.slim.instructions.MakeInstruction;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.QueryTable;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import fitnesse.wikitext.Utils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public abstract class QueryTableBaseTest {
    private WikiPage root;
    private List<Assertion> assertions;
    private String queryTableHeader;
    public QueryTable qt;
    private SlimTestContextImpl testContext;
    protected String headRow;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.assertions = new ArrayList();
        this.queryTableHeader = "|" + this.tableType() + ":fixture|argument|\n" + "|n|2n|\n";
        this.headRow = "[pass(" + this.tableType() + ":fixture), argument], ";
    }

    protected abstract String tableType();

    protected abstract Class<? extends QueryTable> queryTableClass();

    private QueryTable makeQueryTableAndBuildInstructions(String pageContents) throws Exception {
        this.qt = this.makeQueryTable(pageContents);
        this.assertions.addAll(this.qt.getAssertions());
        return this.qt;
    }

    private QueryTable makeQueryTable(String tableText) throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)tableText);
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        Table t = ts.getTable(0);
        this.testContext = new SlimTestContextImpl();
        return this.constructQueryTable(t);
    }

    private QueryTable constructQueryTable(Table t) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class queryTableClass = this.queryTableClass();
        Constructor constructor = queryTableClass.getConstructor(Table.class, String.class, SlimTestContext.class);
        return (QueryTable)constructor.newInstance(t, "id", this.testContext);
    }

    protected void assertQueryResults(String queryRows, List<Object> queryResults, String table) throws Exception {
        this.makeQueryTableAndBuildInstructions(this.queryTableHeader + queryRows);
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"queryTable_id_0", "OK"}), ListUtility.list((String[])new String[]{"queryTable_id_1", "blah"}), ListUtility.list((Object[])new Object[]{"queryTable_id_2", queryResults})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        Assert.assertEquals((Object)table, (Object)this.qt.getTable().toString());
    }

    @Test
    public void instructionsForQueryTable() throws Exception {
        this.makeQueryTableAndBuildInstructions(this.queryTableHeader);
        List expectedInstructions = ListUtility.list((Object[])new Instruction[]{new MakeInstruction("queryTable_id_0", "queryTable_id", "fixture", new Object[]{"argument"}), new CallInstruction("queryTable_id_1", "queryTable_id", "table", new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2n"})})}), new CallInstruction("queryTable_id_2", "queryTable_id", "query")});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    private List<Instruction> instructions() {
        return Assertion.getInstructions((List)this.assertions);
    }

    @Test
    public void nullResultsForNullTable() throws Exception {
        this.assertQueryResults("", ListUtility.list(), "[" + this.headRow + "[n, 2n]" + "]");
    }

    @Test
    public void oneRowThatMatches() throws Exception {
        this.assertQueryResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2"}), ListUtility.list((String[])new String[]{"2n", "4"})})}), "[" + this.headRow + "[n, 2n], " + "[pass(2), pass(4)]" + "]");
    }

    @Test
    public void oneRowFirstCellMatchesSecondCellBlank() throws Exception {
        this.assertQueryResults("|2||\n", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2"}), ListUtility.list((String[])new String[]{"2n", "4"})})}), "[" + this.headRow + "[n, 2n], " + "[pass(2), ignore(4)]" + "]");
    }

    @Test
    public void oneRowThatFails() throws Exception {
        this.assertQueryResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "3"}), ListUtility.list((String[])new String[]{"2n", "5"})})}), "[" + this.headRow + "[n, 2n], " + "[fail(e=2;missing), 4], " + "[fail(a=3;surplus), 5]" + "]");
    }

    @Test
    public void oneRowWithPartialMatch() throws Exception {
        this.assertQueryResults("|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2"}), ListUtility.list((String[])new String[]{"2n", "5"})})}), "[" + this.headRow + "[n, 2n], " + "[pass(2), fail(a=5;e=4)]" + "]");
    }

    @Test
    public void twoMatchingRows() throws Exception {
        this.assertQueryResults("|2|4|\n|3|6|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2"}), ListUtility.list((String[])new String[]{"2n", "4"})}), ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "3"}), ListUtility.list((String[])new String[]{"2n", "6"})})}), "[" + this.headRow + "[n, 2n], " + "[pass(2), pass(4)], " + "[pass(3), pass(6)]" + "]");
    }

    @Test
    public void twoRowsFirstMatchesSecondDoesnt() throws Exception {
        this.assertQueryResults("|3|6|\n|99|99|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2"}), ListUtility.list((String[])new String[]{"2n", "4"})}), ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "3"}), ListUtility.list((String[])new String[]{"2n", "6"})})}), "[" + this.headRow + "[n, 2n], " + "[pass(3), pass(6)], " + "[fail(e=99;missing), 99], " + "[fail(a=2;surplus), 4]" + "]");
    }

    @Test
    public void twoRowsSecondMatchesFirstDoesnt() throws Exception {
        this.assertQueryResults("|99|99|\n|2|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2"}), ListUtility.list((String[])new String[]{"2n", "4"})}), ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "3"}), ListUtility.list((String[])new String[]{"2n", "6"})})}), "[" + this.headRow + "[n, 2n], " + "[fail(e=99;missing), 99], " + "[pass(2), pass(4)], " + "[fail(a=3;surplus), 6]" + "]");
    }

    @Test
    public void fieldInMatchingRowDoesntExist() throws Exception {
        this.assertQueryResults("|3|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "3"})})}), "[" + this.headRow + "[n, 2n], " + "[pass(3), fail(a=field 2n not present;e=4)]" + "]");
        Assert.assertEquals((long)1L, (long)this.testContext.getTestSummary().getRight());
        Assert.assertEquals((long)1L, (long)this.testContext.getTestSummary().getWrong());
    }

    @Test
    public void fieldInSurplusRowDoesntExist() throws Exception {
        this.assertQueryResults("", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "3"})})}), "[" + this.headRow + "[n, 2n], " + "[fail(a=3;surplus), fail(field 2n not present)]" + "]");
        Assert.assertEquals((long)0L, (long)this.testContext.getTestSummary().getRight());
        Assert.assertEquals((long)2L, (long)this.testContext.getTestSummary().getWrong());
    }

    @Test
    public void variablesAreReplacedInMatch() throws Exception {
        this.makeQueryTableAndBuildInstructions(this.queryTableHeader + "|2|$V|\n");
        this.qt.setSymbol("V", "4");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"queryTable_id_0", "OK"}), ListUtility.list((String[])new String[]{"queryTable_id_1", "/__VOID__/"}), ListUtility.list((Object[])new Object[]{"queryTable_id_2", ListUtility.list((Object[])new List[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2"}), ListUtility.list((String[])new String[]{"2n", "4"})})})})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        Assert.assertEquals((Object)("[" + this.headRow + "[n, 2n], " + "[pass(2), pass($V->[4])]" + "]"), (Object)Utils.unescapeWiki((String)this.qt.getTable().toString()));
    }

    @Test
    public void variablesAreReplacedInExpected() throws Exception {
        this.makeQueryTableAndBuildInstructions(this.queryTableHeader + "|2|$V|\n");
        this.qt.setSymbol("V", "5");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"queryTable_id_0", "OK"}), ListUtility.list((String[])new String[]{"queryTable_id_1", "/__VOID__/"}), ListUtility.list((Object[])new Object[]{"queryTable_id_2", ListUtility.list((Object[])new List[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2"}), ListUtility.list((String[])new String[]{"2n", "4"})})})})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        Assert.assertEquals((Object)("[" + this.headRow + "[n, 2n], " + "[pass(2), fail(a=4;e=$V->[5])]" + "]"), (Object)Utils.unescapeWiki((String)this.qt.getTable().toString()));
    }

    @Test
    public void variablesAreReplacedInMissing() throws Exception {
        this.makeQueryTableAndBuildInstructions(this.queryTableHeader + "|3|$V|\n");
        this.qt.setSymbol("V", "5");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"queryTable_id_0", "OK"}), ListUtility.list((String[])new String[]{"queryTable_id_1", "/__VOID__/"}), ListUtility.list((Object[])new Object[]{"queryTable_id_2", ListUtility.list()})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        Assert.assertEquals((Object)("[" + this.headRow + "[n, 2n], " + "[fail(e=3;missing), $V->[5]]" + "]"), (Object)this.qt.getTable().toString());
    }

    @Test
    public void oneRowThatMatchesExpression() throws Exception {
        this.assertQueryResults("|<5|4|\n", ListUtility.list((Object[])new Object[]{ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"n", "2"}), ListUtility.list((String[])new String[]{"2n", "4"})})}), "[" + this.headRow + "[n, 2n], " + "[pass(2<5), pass(4)]" + "]");
    }
}

