/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.slim.SlimClient;
import fitnesse.slim.instructions.CallInstruction;
import fitnesse.slim.instructions.Instruction;
import fitnesse.testsystems.slim.HtmlTableScanner;
import fitnesse.testsystems.slim.SlimTestContext;
import fitnesse.testsystems.slim.SlimTestContextImpl;
import fitnesse.testsystems.slim.Table;
import fitnesse.testsystems.slim.tables.Assertion;
import fitnesse.testsystems.slim.tables.ScenarioTable;
import fitnesse.testsystems.slim.tables.ScriptTable;
import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.wiki.InMemoryPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.ListUtility;

public class ScenarioAndScriptTableTest
extends SlimTestContextImpl {
    private WikiPage root;
    private List<Assertion> assertions;
    private ScenarioTable st;
    private ScriptTable script;

    @Before
    public void setUp() throws Exception {
        this.root = InMemoryPage.makeRoot((String)"root");
        this.assertions = new ArrayList();
        this.clearTestSummary();
    }

    private void makeTables(String tableText) throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)tableText);
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        Table t = ts.getTable(0);
        this.st = new ScenarioTable(t, "s_id", (SlimTestContext)this);
        t = ts.getTable(1);
        this.script = new ScriptTable(t, "id", (SlimTestContext)this);
        this.assertions.addAll(this.st.getAssertions());
        this.assertions.addAll(this.script.getAssertions());
    }

    private List<Instruction> instructions() {
        return Assertion.getInstructions((List)this.assertions);
    }

    @Test
    public void oneInput() throws Exception {
        this.makeTables("!|scenario|myScenario|input|\n|function|@input|\n\n!|script|\n|myScenario|7|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0/scriptTable_s_id_0", "scriptTableActor", "function", new Object[]{"7"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void simpleNameWithUnnamedArgument() throws Exception {
        this.makeTables("!|scenario|f|a||b|\n|function|@a||@b|\n\n!|script|\n|f|1||2|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0/scriptTable_s_id_0", "scriptTableActor", "function", new Object[]{"1", "2"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void manyInputsAndRows() throws Exception {
        this.makeTables("!|scenario|login|user name|password|password|pin|pin|\n|login|@userName|with password|@password|and pin|@pin|\n\n!|script|\n|login|bob|password|xyzzy|pin|7734|\n|login|bill|password|yabba|pin|8892|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0/scriptTable_s_id_0", "scriptTableActor", "loginWithPasswordAndPin", new Object[]{"bob", "xyzzy", "7734"}), new CallInstruction("scriptTable_id_1/scriptTable_s_id_0", "scriptTableActor", "loginWithPasswordAndPin", new Object[]{"bill", "yabba", "8892"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void simpleInputAndOutputPassing() throws Exception {
        this.makeTables("!|scenario|echo|input|giving|output|\n|check|echo|@input|@output|\n\n!|script|\n|echo|7|giving|7|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0/scriptTable_s_id_0", "7"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String scriptTable = ((SlimTable)this.script.getChildren().get(0)).getTable().toString();
        String expectedScript = "[[scenario, echo, input, giving, output], [check, echo, 7, pass(7)]]";
        Assert.assertEquals((Object)expectedScript, (Object)scriptTable);
        String dtHtml = this.script.getTable().toString();
        Assert.assertEquals((long)1L, (long)this.getTestSummary().getRight());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getWrong());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getIgnores());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getExceptions());
    }

    @Test
    public void simpleInputAndOutputFailing() throws Exception {
        this.makeTables("!|scenario|echo|input|giving|output|\n|check|echo|@input|@output|\n\n!|script|\n|echo|7|giving|8|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0/scriptTable_s_id_0", "7"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String scriptTable = ((SlimTable)this.script.getChildren().get(0)).getTable().toString();
        String expectedScript = "[[scenario, echo, input, giving, output], [check, echo, 7, fail(a=7;e=8)]]";
        Assert.assertEquals((Object)expectedScript, (Object)scriptTable);
        String dtHtml = this.script.getTable().toString();
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getRight());
        Assert.assertEquals((long)1L, (long)this.getTestSummary().getWrong());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getIgnores());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getExceptions());
    }

    @Test
    public void inputAndOutputWithSymbol() throws Exception {
        this.makeTables("!|scenario|echo|input|giving|output|\n|check|echo|@input|@output|\n\n!|script|\n|$V=|echo|7|\n|echo|$V|giving|$V|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0", "7"}), ListUtility.list((String[])new String[]{"scriptTable_id_1/scriptTable_s_id_0", "7"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String scriptTable = ((SlimTable)this.script.getChildren().get(0)).getTable().toString();
        String expectedScript = "[[scenario, echo, input, giving, output], [check, echo, $V->[7], pass($V->[7])]]";
        Assert.assertEquals((Object)expectedScript, (Object)scriptTable);
    }

    @Test
    public void scenarioHasTooFewArguments() throws Exception {
        this.makeTables("!|scenario|echo|input|giving|\n|check|echo|@input|@output|\n\n!|script|\n|echo|7|giving|7|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0/scriptTable_s_id_0", "7"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String scriptTable = ((SlimTable)this.script.getChildren().get(0)).getTable().toString();
        String expectedScript = "[[scenario, echo, input, giving], [check, echo, 7, fail(a=7;e=@output)]]";
        Assert.assertEquals((Object)expectedScript, (Object)scriptTable);
    }

    @Test
    public void scenarioExtraArgumentsAreIgnored() throws Exception {
        this.makeTables("!|scenario|echo|input|giving|output||output2|\n|check|echo|@input|@output|\n\n!|script|\n|echo|7|giving|7|\n");
        Map pseudoResults = SlimClient.resultToMap((List)ListUtility.list((Object[])new List[]{ListUtility.list((String[])new String[]{"scriptTable_id_0/scriptTable_s_id_0", "7"})}));
        Assertion.evaluateExpectations((List)this.assertions, (Map)pseudoResults);
        String scriptTable = ((SlimTable)this.script.getChildren().get(0)).getTable().toString();
        String expectedScript = "[[scenario, echo, input, giving, output, , output2], [check, echo, 7, pass(7)]]";
        Assert.assertEquals((Object)expectedScript, (Object)scriptTable);
        String dtHtml = this.script.getTable().toString();
        Assert.assertEquals((long)1L, (long)this.getTestSummary().getRight());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getWrong());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getIgnores());
        Assert.assertEquals((long)0L, (long)this.getTestSummary().getExceptions());
    }

    @Test
    public void callParameterizedScenario() throws Exception {
        this.makeTables("!|scenario|Login user _ with password _|name,password|\n|login|@name|with|@password|\n\n!|script|\n|Login user Bob with password xyzzy|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0/scriptTable_s_id_0", "scriptTableActor", "loginWith", new Object[]{"Bob", "xyzzy"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void callNormalScenarioAsThoughItWereParameterized() throws Exception {
        this.makeTables("!|scenario|Login user|name|with password|password|\n|login|@name|with|@password|\n\n!|script|\n|Login user Bob with password xyzzy|\n");
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0/scriptTable_s_id_0", "scriptTableActor", "loginWith", new Object[]{"Bob", "xyzzy"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void matchesScenarioWithMostArguments() throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)"!|scenario|Login user|name|\n|should not get here|\n\n!|scenario|Login user|name|with password|password|\n|login|@name|with|@password|\n\n!|script|\n|Login user Bob with password xyzzy|\n");
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        ScenarioTable st1 = new ScenarioTable(ts.getTable(0), "s1_id", (SlimTestContext)this);
        ScenarioTable st2 = new ScenarioTable(ts.getTable(1), "s2_id", (SlimTestContext)this);
        this.script = new ScriptTable(ts.getTable(2), "id", (SlimTestContext)this);
        this.assertions.addAll(st1.getAssertions());
        this.assertions.addAll(st2.getAssertions());
        this.assertions.addAll(this.script.getAssertions());
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0/scriptTable_s2_id_0", "scriptTableActor", "loginWith", new Object[]{"Bob", "xyzzy"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void doesntMatchScenarioWithNoArgumentsThatSharesFirstWord() throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)"!|scenario|login |\n|should not get here|\n\n!|scenario|connect to |name|with password|password|\n|login with username|@name |and Password|@password    |\n\n!|script|\n|connect to  |Bob| with password| xyzzy|\n");
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        ScenarioTable st1 = new ScenarioTable(ts.getTable(0), "s1_id", (SlimTestContext)this);
        ScenarioTable st2 = new ScenarioTable(ts.getTable(1), "s2_id", (SlimTestContext)this);
        this.script = new ScriptTable(ts.getTable(2), "id", (SlimTestContext)this);
        this.assertions.addAll(st1.getAssertions());
        this.assertions.addAll(st2.getAssertions());
        this.assertions.addAll(this.script.getAssertions());
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0/scriptTable_s2_id_0", "scriptTableActor", "loginWithUsernameAndPassword", new Object[]{"Bob", "xyzzy"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }

    @Test
    public void dontTryParameterizedForRowWithMultipleCells() throws Exception {
        WikiPageUtil.setPageContents((WikiPage)this.root, (String)"!|scenario|login with |name|\n|should not get here|\n\n!|scenario|connect to |name|with password|password|\n|login with username|@name |and Password|@password    |\n\n!|script|\n|connect to  |Bob| with password| xyzzy|\n");
        HtmlTableScanner ts = new HtmlTableScanner(this.root.getData().getHtml());
        ScenarioTable st1 = new ScenarioTable(ts.getTable(0), "s1_id", (SlimTestContext)this);
        ScenarioTable st2 = new ScenarioTable(ts.getTable(1), "s2_id", (SlimTestContext)this);
        this.script = new ScriptTable(ts.getTable(2), "id", (SlimTestContext)this);
        this.assertions.addAll(st1.getAssertions());
        this.assertions.addAll(st2.getAssertions());
        this.assertions.addAll(this.script.getAssertions());
        List expectedInstructions = ListUtility.list((Object[])new CallInstruction[]{new CallInstruction("scriptTable_id_0/scriptTable_s2_id_0", "scriptTableActor", "loginWithUsernameAndPassword", new Object[]{"Bob", "xyzzy"})});
        Assert.assertEquals((Object)expectedInstructions, (Object)this.instructions());
    }
}

