/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.testsystems.slim.tables;

import fitnesse.testsystems.slim.tables.SlimTable;
import fitnesse.testsystems.slim.tables.SlimTableTest;
import org.junit.Assert;
import org.junit.Test;

public class SlimTableTest {
    @Test
    public void gracefulClassNames() throws Exception {
        this.assertDisgracedClassName("MyClass", "my class");
        this.assertDisgracedClassName("myclass", "myclass");
        this.assertDisgracedClassName("x.y", "x.y");
        this.assertDisgracedClassName("x_y", "x_y");
        this.assertDisgracedClassName("MeAndMrs_jones", "me and mrs_jones");
        this.assertDisgracedClassName("PageCreator", "Page creator.");
        this.assertDisgracedClassName("$symbol", "$symbol");
        this.assertDisgracedClassName("$MySymbol", "$MySymbol");
        this.assertDisgracedClassName("myEmbedded$Symbol", "myEmbedded$Symbol");
    }

    private void assertDisgracedClassName(String disgracedName, String sourceName) {
        Assert.assertEquals((Object)disgracedName, (Object)SlimTable.Disgracer.disgraceClassName((String)sourceName));
    }

    @Test
    public void gracefulMethodNames() throws Exception {
        Assert.assertEquals((Object)"myMethodName", (Object)SlimTable.Disgracer.disgraceMethodName((String)"my method name"));
        Assert.assertEquals((Object)"myMethodName", (Object)SlimTable.Disgracer.disgraceMethodName((String)"myMethodName"));
        Assert.assertEquals((Object)"my_method_name", (Object)SlimTable.Disgracer.disgraceMethodName((String)"my_method_name"));
        Assert.assertEquals((Object)"getStringArgs", (Object)SlimTable.Disgracer.disgraceMethodName((String)"getStringArgs"));
        Assert.assertEquals((Object)"setMyVariableName", (Object)SlimTable.Disgracer.disgraceMethodName((String)"set myVariableName"));
    }

    @Test
    public void replaceSymbolsShouldReplaceSimpleSymbol() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("x", "a");
        Assert.assertEquals((Object)"this is a", (Object)table.replaceSymbols("this is $x"));
    }

    @Test
    public void replaceSymbolsShouldReplaceMoreThanOneSymbol() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("x", "a");
        table.setSymbol("y", "b");
        Assert.assertEquals((Object)"this is a and b", (Object)table.replaceSymbols("this is $x and $y"));
    }

    @Test
    public void replaceSymbolsShouldConcatenate() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("x", "a");
        table.setSymbol("y", "b");
        Assert.assertEquals((Object)"this is ab", (Object)table.replaceSymbols("this is $x$y"));
    }

    @Test
    public void replaceSymbolsShouldReplaceSameSymbolMoreThanOnce() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("x", "a");
        Assert.assertEquals((Object)"this is a and a again", (Object)table.replaceSymbols("this is $x and $x again"));
    }

    @Test
    public void replaceSymbolsShouldMatchFullSymbolName() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("V", "v");
        table.setSymbol("VX", "x");
        String actual = table.replaceSymbols("$V $VX");
        Assert.assertEquals((Object)"v x", (Object)actual);
    }

    @Test
    public void replaceSymbolsFullExpansion_ShouldReplaceSimpleSymbol() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("x", "a");
        Assert.assertEquals((Object)"this is $x->[a]", (Object)table.replaceSymbolsWithFullExpansion("this is $x"));
    }

    @Test
    public void replaceSymbolsFullExpansion_ShouldReplaceMoreThanOneSymbol() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("x", "a");
        table.setSymbol("y", "b");
        Assert.assertEquals((Object)"this is $x->[a] and $y->[b]", (Object)table.replaceSymbolsWithFullExpansion("this is $x and $y"));
    }

    @Test
    public void replaceSymbolsFullExpansion_ShouldReplaceSameSymbolMoreThanOnce() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("x", "a");
        Assert.assertEquals((Object)"this is $x->[a] and $x->[a] again", (Object)table.replaceSymbolsWithFullExpansion("this is $x and $x again"));
    }

    @Test
    public void replaceSymbolsFullExpansion_ShouldMatchFullSymbolName() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("V", "v");
        table.setSymbol("VX", "x");
        String actual = table.replaceSymbolsWithFullExpansion("$V $VX");
        Assert.assertEquals((Object)"$V->[v] $VX->[x]", (Object)actual);
    }

    @Test
    public void replaceSymbols_ShouldReplaceConcutenatedSymbols() throws Exception {
        MockTable table = new MockTable();
        table.setSymbol("x", "1");
        table.setSymbol("y", "1");
        Assert.assertEquals((Object)"this is $x->[1]1 and $y->[1]1", (Object)table.replaceSymbolsWithFullExpansion("this is $x1 and $y1"));
    }
}

