/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.tools;

import fitnesse.tools.LicenseManager;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import util.FileUtil;
import util.RegexTestCase;

public class LicenseManagerTest {
    private final String dir = "toolsTempTestDirectory";
    private final String licenseText = "// Copyright (C) 2003,2004,2005 by Object Mentor, Inc. All rights reserved.\n// Released under the terms of the GNU General Public License version 2 or later.\n";

    @Before
    public void setup() {
        this.cleanup();
        FileUtil.createDir((String)"toolsTempTestDirectory");
        FileUtil.createFile((String)"toolsTempTestDirectory/license", (String)"// Copyright (C) 2003,2004,2005 by Object Mentor, Inc. All rights reserved.\n// Released under the terms of the GNU General Public License version 2 or later.\n");
    }

    @After
    public void cleanup() {
        FileUtil.deleteFileSystemDirectory((String)"toolsTempTestDirectory");
    }

    @Test
    public void removeLicenseFromOneFile() throws Exception {
        File testDir = FileUtil.createDir((String)"toolsTempTestDirectory");
        File fileWithLicense = new File(testDir, "fileWithLicense.java");
        FileUtil.createFile((File)fileWithLicense, (String)"// Copyright (C) 2003,2004,2005 by Object Mentor, Inc. All rights reserved.\n// Released under the terms of the GNU General Public License version 2 or later.\nxxx\n");
        LicenseManager.main((String[])new String[]{"-r", "toolsTempTestDirectory"});
        RegexTestCase.assertMatches((String)"xxx$", (String)FileUtil.getFileContent((File)fileWithLicense));
    }

    @Test
    public void removeLicensesFromAllFiles() throws Exception {
        String[] files;
        FileUtil.makeDir((String)"toolsTempTestDirectory/x");
        FileUtil.makeDir((String)"toolsTempTestDirectory/x/y");
        for (String fileName : files = new String[]{"f1.java", "x/f2.java", "x/y/f3.java", "x/y/f4.java"}) {
            FileUtil.createFile((String)("toolsTempTestDirectory/" + fileName), (String)"// Copyright (C) 2003,2004,2005 by Object Mentor, Inc. All rights reserved.\n// Released under the terms of the GNU General Public License version 2 or later.\nyyy\n");
        }
        LicenseManager.main((String[])new String[]{"-r", "toolsTempTestDirectory"});
        for (String fileName : files) {
            RegexTestCase.assertMatches((String)"yyy$", (String)FileUtil.getFileContent((String)("toolsTempTestDirectory/" + fileName)));
        }
    }

    @Test
    public void doesNotRemoveLicenseFromNonJavaFile() throws Exception {
        File testDir = FileUtil.createDir((String)"toolsTempTestDirectory");
        File fileWithLicense = new File(testDir, "fileWithLicense");
        FileUtil.createFile((File)fileWithLicense, (String)"// Copyright (C) 2003,2004,2005 by Object Mentor, Inc. All rights reserved.\n// Released under the terms of the GNU General Public License version 2 or later.\nxxx\n");
        LicenseManager.main((String[])new String[]{"-r", "toolsTempTestDirectory"});
        Assert.assertEquals((Object)"// Copyright (C) 2003,2004,2005 by Object Mentor, Inc. All rights reserved.\n// Released under the terms of the GNU General Public License version 2 or later.\nxxx\n", (Object)FileUtil.getFileContent((File)fileWithLicense));
    }

    @Test
    public void addLicenseToFile() throws Exception {
        File testDir = FileUtil.createDir((String)"toolsTempTestDirectory");
        File fileWithLicense = new File(testDir, "fileWithLicense.java");
        FileUtil.createFile((File)fileWithLicense, (String)"xxx\n");
        LicenseManager.main((String[])new String[]{"toolsTempTestDirectory/license", "toolsTempTestDirectory"});
        String actual = FileUtil.getFileContent((File)fileWithLicense).replaceAll("\r", "");
        Assert.assertEquals((Object)"// Copyright (C) 2003,2004,2005 by Object Mentor, Inc. All rights reserved.\n// Released under the terms of the GNU General Public License version 2 or later.\nxxx\n", (Object)actual);
    }

    @Test
    public void addLicensesToAllFiles() throws Exception {
        String[] files;
        FileUtil.makeDir((String)"toolsTempTestDirectory/x");
        FileUtil.makeDir((String)"toolsTempTestDirectory/x/y");
        for (String fileName : files = new String[]{"f1.java", "x/f2.java", "x/y/f3.java", "x/y/f4.java"}) {
            FileUtil.createFile((String)("toolsTempTestDirectory/" + fileName), (String)"yyy\n");
        }
        LicenseManager.main((String[])new String[]{"toolsTempTestDirectory/license", "toolsTempTestDirectory"});
        for (String fileName : files) {
            String actual = FileUtil.getFileContent((String)("toolsTempTestDirectory/" + fileName)).replaceAll("\r", "");
            Assert.assertEquals((Object)"// Copyright (C) 2003,2004,2005 by Object Mentor, Inc. All rights reserved.\n// Released under the terms of the GNU General Public License version 2 or later.\nyyy\n", (Object)actual);
        }
    }
}

