/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.util;

import fitnesse.util.HtmlParserTools;
import org.htmlparser.Node;
import org.htmlparser.Parser;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.lexer.Page;
import org.htmlparser.tags.Div;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.junit.Assert;
import org.junit.Test;

public class HtmlParserToolsTest {
    @Test
    public void shoudlMakeExactCopy() throws ParserException, CloneNotSupportedException {
        String html = "<div class='foo'>funky <em>content</em></div>";
        Parser parser = new Parser(new Lexer(new Page(html)));
        NodeList tree = parser.parse(null);
        NodeList cloneTree = HtmlParserTools.deepClone((NodeList)tree);
        System.out.println(tree.toString());
        System.out.println(cloneTree.toString());
        Assert.assertEquals((Object)html, (Object)cloneTree.toHtml());
        Assert.assertEquals((Object)tree.toString(), (Object)cloneTree.toString());
        Assert.assertFalse((tree.elementAt(0).getChildren().elementAt(1) == cloneTree.elementAt(0).getChildren().elementAt(1) ? 1 : 0) != 0);
        Assert.assertFalse((tree.elementAt(0).getChildren().elementAt(1).getParent() == cloneTree.elementAt(0).getChildren().elementAt(1).getParent() ? 1 : 0) != 0);
    }

    @Test
    public void shouldAlsoCloneAttributes() throws ParserException, CloneNotSupportedException {
        String html = "<div class='foo'>funky <em>content</em></div>";
        Parser parser = new Parser(new Lexer(new Page(html)));
        NodeList tree = parser.parse(null);
        NodeList cloneTree = HtmlParserTools.deepClone((NodeList)tree);
        Assert.assertSame(Div.class, cloneTree.elementAt(0).getClass());
        ((Div)cloneTree.elementAt(0)).setAttribute("id", "blah-div");
        Assert.assertFalse((boolean)tree.toHtml().equals(cloneTree.toHtml()));
    }

    @Test
    public void flatCloneShouldJustGiveACopyOfANode() throws ParserException {
        String html = "<div class='foo'>funky <em>content</em></div>";
        Parser parser = new Parser(new Lexer(new Page(html)));
        NodeList tree = parser.parse(null);
        Node copy = HtmlParserTools.flatClone((Node)tree.elementAt(0));
        Assert.assertNull((Object)copy.getParent());
        Assert.assertEquals((long)0L, (long)copy.getChildren().size());
    }
}

