/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageVersionPruner;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.zip.ZipFileVersionsController;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import util.FileUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileSystemPageZipFileVersioningTest
extends TestCase {
    public FileSystemPage page;
    private VersionInfo firstVersion;
    private PageCrawler crawler;
    private WikiPage root;

    public void setUp() throws Exception {
        PageVersionPruner.daysTillVersionsExpire = 1;
        this.root = new FileSystemPage("testDir", "RooT");
        this.crawler = this.root.getPageCrawler();
        this.page = (FileSystemPage)this.crawler.addPage(this.root, PathParser.parse((String)"PageOne"), "original content");
        PageData data = this.page.getData();
        this.firstVersion = this.page.commit(data);
    }

    public void tearDown() throws Exception {
        FileUtil.deleteFileSystemDirectory((String)"testDir");
    }

    public void testSave() throws Exception {
        String dirPath = this.page.getFileSystemPath();
        File dir = new File(dirPath);
        String[] filenames = dir.list();
        List<String> list = Arrays.asList(filenames);
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)list.contains(this.firstVersion + ".zip"));
    }

    public void testLoad() throws Exception {
        PageData data = this.page.getData();
        data.setContent("new content");
        VersionInfo version = this.page.commit(data);
        PageData loadedData = this.page.getDataVersion(version.getName());
        FileSystemPageZipFileVersioningTest.assertEquals((String)"original content", (String)loadedData.getContent());
    }

    public void testGetVersions() throws Exception {
        Set versionNames = this.page.getData().getVersions();
        FileSystemPageZipFileVersioningTest.assertEquals((int)1, (int)versionNames.size());
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)versionNames.contains(this.firstVersion));
    }

    public void testSubWikisDontInterfere() throws Exception {
        this.crawler.addPage((WikiPage)this.page, PathParser.parse((String)"SubPage"), "sub page content");
        try {
            this.page.commit(this.page.getData());
        }
        catch (Exception e) {
            FileSystemPageZipFileVersioningTest.fail((String)("this exception should not have been thrown: " + e.getMessage()));
        }
    }

    public void testTwoVersions() throws Exception {
        PageData data = this.page.getData();
        data.setContent("new content");
        VersionInfo secondVersion = this.page.commit(data);
        Set versionNames = this.page.getData().getVersions();
        FileSystemPageZipFileVersioningTest.assertEquals((int)2, (int)versionNames.size());
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)versionNames.contains(this.firstVersion));
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)versionNames.contains(secondVersion));
    }

    public void testVersionsExpire() throws Exception {
        PageVersionPruner.daysTillVersionsExpire = 3;
        PageData data = this.page.makePageData();
        Set versions = data.getVersions();
        for (VersionInfo version : versions) {
            this.page.removeVersion(version.toString());
        }
        data.getProperties().setLastModificationTime(ZipFileVersionsController.dateFormat().parse("20031213000000"));
        this.page.makeVersion(data);
        data.getProperties().setLastModificationTime(ZipFileVersionsController.dateFormat().parse("20031214000000"));
        this.page.makeVersion(data);
        data.getProperties().setLastModificationTime(ZipFileVersionsController.dateFormat().parse("20031215000000"));
        this.page.makeVersion(data);
        data.getProperties().setLastModificationTime(ZipFileVersionsController.dateFormat().parse("20031216000000"));
        this.page.makeVersion(data);
        versions = this.page.makePageData().getVersions();
        PageVersionPruner.pruneVersions((FileSystemPage)this.page, (Collection)versions);
        versions = this.page.makePageData().getVersions();
        FileSystemPageZipFileVersioningTest.assertEquals((int)3, (int)versions.size());
        LinkedList versionsList = new LinkedList(versions);
        Collections.sort(versionsList);
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)((VersionInfo)versionsList.get(0)).toString().endsWith("20031214000000"));
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)((VersionInfo)versionsList.get(1)).toString().endsWith("20031215000000"));
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)((VersionInfo)versionsList.get(2)).toString().endsWith("20031216000000"));
    }

    public void testGetContent() throws Exception {
        WikiPagePath alpha = PathParser.parse((String)"AlphaAlpha");
        WikiPage a = this.crawler.addPage(this.root, alpha, "a");
        PageData data = a.getData();
        FileSystemPageZipFileVersioningTest.assertEquals((String)"a", (String)data.getContent());
    }

    public void testReplaceContent() throws Exception {
        WikiPagePath alpha = PathParser.parse((String)"AlphaAlpha");
        WikiPage page = this.crawler.addPage(this.root, alpha, "a");
        PageData data = page.getData();
        data.setContent("b");
        page.commit(data);
        FileSystemPageZipFileVersioningTest.assertEquals((String)"b", (String)page.getData().getContent());
    }

    public void testSetAttributes() throws Exception {
        PageData data = this.root.getData();
        data.setAttribute("Test", "true");
        data.setAttribute("Search", "true");
        this.root.commit(data);
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)this.root.getData().hasAttribute("Test"));
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)this.root.getData().hasAttribute("Search"));
        FileSystemPageZipFileVersioningTest.assertEquals((String)"true", (String)this.root.getData().getAttribute("Test"));
    }

    public void testSimpleVersionTasks() throws Exception {
        WikiPagePath path = PathParser.parse((String)"MyPageOne");
        WikiPage page = this.crawler.addPage(this.root, path, "old content");
        PageData data = page.getData();
        data.setContent("new content");
        VersionInfo previousVersion = page.commit(data);
        data = page.getData();
        Set versions = data.getVersions();
        FileSystemPageZipFileVersioningTest.assertEquals((int)1, (int)versions.size());
        FileSystemPageZipFileVersioningTest.assertEquals((boolean)true, (boolean)versions.contains(previousVersion));
        PageData loadedData = page.getDataVersion(previousVersion.getName());
        FileSystemPageZipFileVersioningTest.assertSame((Object)page, (Object)loadedData.getWikiPage());
        FileSystemPageZipFileVersioningTest.assertEquals((String)"old content", (String)loadedData.getContent());
    }

    public void testUserNameIsInVersionName() throws Exception {
        WikiPagePath testPagePath = PathParser.parse((String)"TestPage");
        WikiPage testPage = this.crawler.addPage(this.root, testPagePath, "version1");
        PageData data = testPage.getData();
        data.setAttribute("LastModifyingUser", "Aladdin");
        testPage.commit(data);
        data = testPage.getData();
        data.setAttribute("LastModifyingUser", "Joe");
        VersionInfo record = testPage.commit(data);
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)record.getName().startsWith("Aladdin"));
    }

    public void testNoVersionException() throws Exception {
        WikiPagePath pageOnePath = PathParser.parse((String)"PageOne");
        WikiPage page = this.crawler.addPage(this.root, pageOnePath, "old content");
        try {
            page.getDataVersion("abc");
            FileSystemPageZipFileVersioningTest.fail((String)"a NoSuchVersionException should have been thrown");
        }
        catch (NoSuchVersionException e) {
            FileSystemPageZipFileVersioningTest.assertEquals((String)"There is no version 'abc'", (String)e.getMessage());
        }
    }

    public void testUnicodeInVersions() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"SomePage"), "\uba80\uba81\uba82\uba83");
        PageData data = page.getData();
        data.setContent("blah");
        VersionInfo info = page.commit(data);
        data = page.getDataVersion(info.getName());
        String expected = "\uba80\uba81\uba82\uba83";
        String actual = data.getContent();
        FileSystemPageZipFileVersioningTest.assertEquals((String)expected, (String)actual);
    }

    public void testVersionedPropertiedLoadedProperly() throws Exception {
        WikiPage page = this.crawler.addPage(this.root, PathParser.parse((String)"TestPage"));
        PageData data = page.getData();
        WikiPageProperties oldProps = data.getProperties();
        WikiPageProperties props = new WikiPageProperties();
        props.set("MyProp", "my value");
        data.setProperties(props);
        page.commit(data);
        data.setProperties(oldProps);
        VersionInfo version = page.commit(data);
        PageData versionedData = page.getDataVersion(version.getName());
        WikiPageProperties versionedProps = versionedData.getProperties();
        FileSystemPageZipFileVersioningTest.assertTrue((boolean)versionedProps.has("MyProp"));
        FileSystemPageZipFileVersioningTest.assertEquals((String)"my value", (String)versionedProps.get("MyProp"));
    }
}

