/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageType;
import fitnesse.wiki.ReadOnlyPageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.ParsedPage;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Paths;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolTreeWalker;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.parser.VariableFinder;
import fitnesse.wikitext.parser.WikiSourcePage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import util.Clock;
import util.Maybe;
import util.StringUtil;

public class PageData
implements ReadOnlyPageData,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PropertyLAST_MODIFIED = "LastModified";
    public static final String PropertyHELP = "Help";
    public static final String PropertyPRUNE = "Prune";
    public static final String PropertySEARCH = "Search";
    public static final String PropertyRECENT_CHANGES = "RecentChanges";
    public static final String PropertyFILES = "Files";
    public static final String PropertyWHERE_USED = "WhereUsed";
    public static final String PropertyREFACTOR = "Refactor";
    public static final String PropertyPROPERTIES = "Properties";
    public static final String PropertyVERSIONS = "Versions";
    public static final String PropertyEDIT = "Edit";
    public static final String PropertySUITES = "Suites";
    public static final String PAGE_TYPE_ATTRIBUTE = "PageType";
    public static final String[] PAGE_TYPE_ATTRIBUTES = new String[]{PageType.STATIC.toString(), PageType.TEST.toString(), PageType.SUITE.toString()};
    public static final String[] ACTION_ATTRIBUTES = new String[]{"Edit", "Versions", "Properties", "Refactor", "WhereUsed"};
    public static final String[] NAVIGATION_ATTRIBUTES = new String[]{"RecentChanges", "Files", "Search"};
    public static final String[] NON_SECURITY_ATTRIBUTES = StringUtil.combineArrays((String[][])new String[][]{ACTION_ATTRIBUTES, NAVIGATION_ATTRIBUTES});
    public static final String PropertySECURE_READ = "secure-read";
    public static final String PropertySECURE_WRITE = "secure-write";
    public static final String PropertySECURE_TEST = "secure-test";
    public static final String[] SECURITY_ATTRIBUTES = new String[]{"secure-read", "secure-write", "secure-test"};
    public static final String LAST_MODIFYING_USER = "LastModifyingUser";
    public static final String SUITE_SETUP_NAME = "SuiteSetUp";
    public static final String SUITE_TEARDOWN_NAME = "SuiteTearDown";
    private transient WikiPage wikiPage;
    private String content;
    private WikiPageProperties properties = new WikiPageProperties();
    private Set<VersionInfo> versions;
    public static final String COMMAND_PATTERN = "COMMAND_PATTERN";
    public static final String TEST_RUNNER = "TEST_RUNNER";
    public static final String PATH_SEPARATOR = "PATH_SEPARATOR";
    private transient ParsedPage parsedPage;

    public PageData(WikiPage page) {
        this.wikiPage = page;
        this.initializeAttributes();
        this.versions = new HashSet();
    }

    public PageData(WikiPage page, String content) {
        this(page);
        this.setContent(content);
    }

    public PageData(PageData data) {
        this(data.getWikiPage(), data.content);
        this.properties = new WikiPageProperties(data.properties);
        this.versions.addAll(data.versions);
        this.parsedPage = data.parsedPage;
    }

    public void initializeAttributes() {
        if (!this.isErrorLogsPage()) {
            this.properties.set(PropertyEDIT, Boolean.toString(true));
            this.properties.set(PropertyPROPERTIES, Boolean.toString(true));
            this.properties.set(PropertyREFACTOR, Boolean.toString(true));
        }
        this.properties.set(PropertyWHERE_USED, Boolean.toString(true));
        this.properties.set(PropertyRECENT_CHANGES, Boolean.toString(true));
        this.properties.set(PropertyFILES, Boolean.toString(true));
        this.properties.set(PropertyVERSIONS, Boolean.toString(true));
        this.properties.set(PropertySEARCH, Boolean.toString(true));
        this.properties.setLastModificationTime(Clock.currentDate());
        this.initTestOrSuiteProperty();
    }

    private void initTestOrSuiteProperty() {
        String pageName = this.wikiPage.getName();
        if (pageName == null) {
            this.handleInvalidPageName(this.wikiPage);
            return;
        }
        if (this.isErrorLogsPage()) {
            return;
        }
        PageType pageType = PageType.getPageTypeForPageName((String)pageName);
        if (PageType.STATIC.equals((Object)pageType)) {
            return;
        }
        this.properties.set(pageType.toString(), Boolean.toString(true));
    }

    private boolean isErrorLogsPage() {
        PageCrawler crawler = this.wikiPage.getPageCrawler();
        String relativePagePath = crawler.getRelativeName(crawler.getRoot(this.wikiPage), this.wikiPage);
        return relativePagePath.startsWith("ErrorLogs");
    }

    private void handleInvalidPageName(WikiPage wikiPage) {
        try {
            String msg = "WikiPage " + wikiPage + " does not have a valid name!" + wikiPage.getName();
            System.err.println(msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public WikiPageProperties getProperties() {
        return this.properties;
    }

    public String getAttribute(String key) {
        return this.properties.get(key);
    }

    public void removeAttribute(String key) {
        this.properties.remove(key);
    }

    public void setAttribute(String key, String value) {
        this.properties.set(key, value);
    }

    public void setAttribute(String key) {
        this.properties.set(key);
    }

    public boolean hasAttribute(String attribute) {
        return this.properties.has(attribute);
    }

    public void setProperties(WikiPageProperties properties) {
        this.properties = properties;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = StringUtil.stripCarriageReturns((String)content);
    }

    public String getHtml() {
        return this.getParsedPage().toHtml();
    }

    public String getVariable(String name) {
        Maybe variable = new VariableFinder(this.getParsingPage()).findVariable(name);
        if (variable.isNothing()) {
            return null;
        }
        return this.getParsingPage().renderVariableValue((String)variable.getValue());
    }

    public ParsedPage getParsedPage() {
        if (this.parsedPage == null) {
            this.parsedPage = new ParsedPage((SourcePage)new WikiSourcePage(this.wikiPage), this.content);
        }
        return this.parsedPage;
    }

    private Symbol getSyntaxTree() {
        return this.getParsedPage().getSyntaxTree();
    }

    private ParsingPage getParsingPage() {
        return this.getParsedPage().getParsingPage();
    }

    public void setWikiPage(WikiPage page) {
        this.wikiPage = page;
    }

    public WikiPage getWikiPage() {
        return this.wikiPage;
    }

    public List<String> getClasspaths() {
        Symbol tree = this.getSyntaxTree();
        return new Paths((Translator)new HtmlTranslator((SourcePage)new WikiSourcePage(this.wikiPage), this.getParsingPage())).getPaths(tree);
    }

    public List<String> getXrefPages() {
        ArrayList<String> xrefPages = new ArrayList<String>();
        this.getSyntaxTree().walkPreOrder((SymbolTreeWalker)new /* Unavailable Anonymous Inner Class!! */);
        return xrefPages;
    }

    public Set<VersionInfo> getVersions() {
        return this.versions;
    }

    public void addVersions(Collection<VersionInfo> newVersions) {
        this.versions.addAll(newVersions);
    }

    public boolean isEmpty() {
        return this.getContent() == null || this.getContent().length() == 0;
    }
}

