/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.ExternalSuitePage;
import fitnesse.wiki.ExternalTestPage;
import fitnesse.wiki.FileSystemPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.WikiWordPath;
import java.util.ArrayList;
import java.util.List;
import util.DiskFileSystem;
import util.FileSystem;

public class PageRepository {
    private FileSystem fileSystem;

    public PageRepository() {
        this.fileSystem = new DiskFileSystem();
    }

    public PageRepository(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public WikiPage makeChildPage(String name, FileSystemPage parent) {
        String path = parent.getFileSystemPath() + "/" + name;
        if (this.hasContentChild(path).booleanValue()) {
            return new FileSystemPage(name, parent, this.fileSystem);
        }
        if (this.hasHtmlChild(path).booleanValue()) {
            return new ExternalSuitePage(path, name, (WikiPage)parent, this.fileSystem);
        }
        return new FileSystemPage(name, parent, this.fileSystem);
    }

    private Boolean hasContentChild(String path) {
        for (String child : this.fileSystem.list(path)) {
            if (!child.equals("content.txt")) continue;
            return true;
        }
        return false;
    }

    private Boolean hasHtmlChild(String path) {
        if (path.endsWith(".html")) {
            return true;
        }
        for (String child : this.fileSystem.list(path)) {
            if (!this.hasHtmlChild(path + "/" + child).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<WikiPage> findChildren(ExternalSuitePage parent) {
        ArrayList<WikiPage> children = new ArrayList<WikiPage>();
        for (String child : this.fileSystem.list(parent.getFileSystemPath())) {
            String childPath = parent.getFileSystemPath() + "/" + child;
            if (child.endsWith(".html")) {
                children.add((WikiPage)new ExternalTestPage(childPath, WikiWordPath.makeWikiWord((String)child.replace(".html", "")), (WikiPage)parent, this.fileSystem));
                continue;
            }
            if (!this.hasHtmlChild(childPath).booleanValue()) continue;
            children.add((WikiPage)new ExternalSuitePage(childPath, WikiWordPath.makeWikiWord((String)child), (WikiPage)parent, this.fileSystem));
        }
        return children;
    }
}

