/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageData;
import fitnesse.wiki.PageVersionPruner;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.ProxyPage;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;

public class WikiPageActions {
    private WikiPage page;
    private boolean addChild;
    private boolean pageHistory;

    public WikiPageActions(WikiPage page) {
        this.page = page;
    }

    public boolean isTestPage() {
        return this.hasAction("Test");
    }

    public boolean isSuitePage() {
        return this.hasAction("Suite");
    }

    public boolean isDefaultPage() {
        return !this.isTestPage() && !this.isSuitePage();
    }

    public boolean isWithEdit() {
        return this.hasAction("Edit");
    }

    public boolean isWithProperties() {
        return this.hasAction("Properties");
    }

    public boolean isWithRefactor() {
        return this.hasAction("Refactor");
    }

    public boolean isWithWhereUsed() {
        return this.hasAction("WhereUsed");
    }

    public boolean isWithSearch() {
        return this.hasAction("Search");
    }

    public boolean isWithFiles() {
        return this.hasAction("Files");
    }

    public boolean isWithVersions() {
        return this.hasAction("Versions") && PageVersionPruner.daysTillVersionsExpire > 0;
    }

    public boolean isWithRecentChanges() {
        return this.hasAction("RecentChanges");
    }

    public boolean isWithUserGuide() {
        return this.page != null;
    }

    public boolean isImported() {
        PageData data = this.getData();
        return data != null && WikiImportProperty.isImported((PageData)data);
    }

    private boolean hasAction(String action) {
        PageData data = this.getData();
        return data != null && data.hasAttribute(action);
    }

    private boolean isTestablePage() {
        return this.hasAction("Test") || this.hasAction("Suite");
    }

    private PageData getData() {
        if (this.page != null) {
            try {
                return this.page.getData();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getLocalPageName() {
        if (this.page != null) {
            WikiPagePath localPagePath = this.page.getPageCrawler().getFullPath(this.page);
            return PathParser.render((WikiPagePath)localPagePath);
        }
        return null;
    }

    public String getLocalOrRemotePageName() {
        String localOrRemotePageName = this.getLocalPageName();
        if (this.page instanceof ProxyPage) {
            localOrRemotePageName = ((ProxyPage)this.page).getThisPageUrl();
        }
        return localOrRemotePageName;
    }

    public boolean isNewWindowIfRemote() {
        if (this.page != null) {
            return this.page.isOpenInNewWindow();
        }
        return false;
    }
}

