/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext;

import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimSerializer;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.test.TestRoot;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PerformanceTest {
    private String tablePageContent = "";
    private String definePageContent = "";

    public PerformanceTest() {
        StringBuilder table = new StringBuilder();
        StringBuilder define = new StringBuilder();
        for (int i = 0; i < 2000; ++i) {
            table.append("|aaaaaaaaaa|bbbbbbbbbb|cccccccccc|dddddddddd|eeeeeeeeee|ffffffffff|gggggggggg|hhhhhhhhhh|iiiiiiiiiii|jjjjjjjjjj|kkkkkkkkkk|lllllllllll|mmmmmmmmmm|nnnnnnnnnn|oooooooooo|pppppppppp|qqqqqqqqqq|rrrrrrrrrr|ssssssssss|tttttttttt|uuuuuuuuuu|vvvvvvvvvv|wwwwwwwwww|xxxxxxxxxx|yyyyyyyyyy|zzzzzzzzzz|\n");
            define.append("!define variable").append(i).append(" {aaaaaaaaaa bbbbbbbbbb cccccccccc dddddddddd eeeeeeeeee ffffffffff gggggggggg hhhhhhhhhh iiiiiiiiii jjjjjjjjjj kkkkkkkkkk llllllllll mmmmmmmmmm nnnnnnnnnn oooooooooo pppppppppp qqqqqqqqqq rrrrrrrrrr ssssssssss tttttttttt uuuuuuuuuu vvvvvvvvvv wwwwwwwwww xxxxxxxxxx yyyyyyyyyy zzzzzzzzzz}\n");
        }
        this.tablePageContent = table.toString();
        this.definePageContent = define.toString();
    }

    @Test
    public void NewParserTable() throws Exception {
        this.runNewParser(this.tablePageContent);
    }

    @Test
    public void NewParserDefine() throws Exception {
        this.runNewParser(this.definePageContent);
    }

    private void runNewParser(String input) throws Exception {
        long start = System.currentTimeMillis();
        WikiPage page = new TestRoot().makePage("NewTest");
        Symbol list = Parser.make((ParsingPage)new ParsingPage((SourcePage)new WikiSourcePage(page)), (String)input).parse();
        System.out.println(System.currentTimeMillis() - start);
        start = System.currentTimeMillis();
        new HtmlTranslator((SourcePage)new WikiSourcePage(page), new ParsingPage((SourcePage)new WikiSourcePage(page))).translateTree(list);
        System.out.println(System.currentTimeMillis() - start);
        Assert.assertEquals((Object)"done", (Object)"done");
    }

    @Test
    public void listDeserializationTest() {
        ArrayList<String> objects = new ArrayList<String>();
        for (int i = 0; i < 10000; ++i) {
            objects.add(new String("This is string " + i));
        }
        String serializedList = SlimSerializer.serialize(objects);
        long start = System.currentTimeMillis();
        List result = SlimDeserializer.deserialize((String)serializedList);
        System.out.println(System.currentTimeMillis() - start);
        Assert.assertEquals(objects, (Object)result);
    }
}

