/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.parser.ContentsItemBuilder;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import util.Maybe;

public class Contents
extends SymbolType
implements Rule,
Translation {
    public static final String FILTER_TOC = "FILTER_TOC";
    public static final String HELP_TOC = "HELP_TOC";
    public static final String MORE_SUFFIX_DEFAULT = " ...";
    public static final String MORE_SUFFIX_TOC = "MORE_SUFFIX_TOC";
    public static final String PROPERTY_TOC = "PROPERTY_TOC";
    public static final String REGRACE_TOC = "REGRACE_TOC";

    public Contents() {
        super("Contents");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!contents"));
        this.wikiRule((Rule)this);
        this.htmlTranslation((Translation)this);
    }

    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol body = parser.parseToEnd(SymbolType.Newline);
        for (Symbol option : body.getChildren()) {
            if (option.isType(SymbolType.Whitespace)) continue;
            if (!option.getContent().startsWith("-")) {
                return Symbol.nothing;
            }
            current.add(option);
        }
        current.evaluateVariables(new String[]{HELP_TOC, REGRACE_TOC, PROPERTY_TOC, FILTER_TOC, MORE_SUFFIX_TOC}, parser.getVariableSource());
        return new Maybe((Object)current);
    }

    public String toTarget(Translator translator, Symbol symbol) {
        ContentsItemBuilder itemBuilder = new ContentsItemBuilder(symbol, 1);
        HtmlTag contentsDiv = HtmlUtil.makeDivTag((String)"contents");
        contentsDiv.add((HtmlElement)HtmlUtil.makeBold((String)"Contents:"));
        HtmlTag div = itemBuilder.buildLevel(translator.getPage(), contentsDiv);
        return div.html();
    }
}

