/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.FitNesseVersion;
import fitnesse.wikitext.parser.Comment;
import fitnesse.wikitext.parser.Define;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Include;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Preformat;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Variable;
import java.util.HashMap;
import util.Maybe;

public class ParsingPage {
    private static final SymbolProvider variableDefinitionSymbolProvider = new SymbolProvider(new SymbolType[]{Literal.symbolType, new Define(), new Include(), SymbolType.CloseLiteral, Comment.symbolType, SymbolType.Whitespace, SymbolType.Newline, Variable.symbolType, Preformat.symbolType, SymbolType.ClosePreformat, SymbolType.Text});
    private SourcePage page;
    private SourcePage namedPage;
    private HashMap<String, HashMap<String, Maybe<String>>> cache;

    public ParsingPage(SourcePage page) {
        this(page, page, new HashMap());
    }

    public ParsingPage copy() {
        return new ParsingPage(this.page, this.page, this.cache);
    }

    public ParsingPage copyForPage(SourcePage page) {
        return new ParsingPage(page, page, this.cache);
    }

    public ParsingPage copyForNamedPage(SourcePage namedPage) {
        return new ParsingPage(this.page, namedPage, this.cache);
    }

    private ParsingPage(SourcePage page, SourcePage namedPage, HashMap<String, HashMap<String, Maybe<String>>> cache) {
        this.page = page;
        this.namedPage = namedPage;
        this.cache = cache;
    }

    public SourcePage getPage() {
        return this.page;
    }

    public SourcePage getNamedPage() {
        return this.namedPage;
    }

    public Maybe<String> getSpecialVariableValue(String key) {
        String value;
        FitNesseContext context;
        FitNesse fitnesse = FitNesse.FITNESSE_INSTANCE;
        FitNesseContext fitNesseContext = context = fitnesse != null ? fitnesse.getContext() : null;
        if (key.equals("RUNNING_PAGE_NAME")) {
            value = this.page.getName();
        } else if (key.equals("RUNNING_PAGE_PATH")) {
            value = this.page.getPath();
        } else if (key.equals("PAGE_NAME")) {
            value = this.namedPage.getName();
        } else if (key.equals("PAGE_PATH")) {
            value = this.namedPage.getPath();
        } else if (key.equals("FITNESSE_PORT")) {
            value = Integer.toString(context != null ? context.port : -1);
        } else if (key.equals("FITNESSE_ROOTPATH")) {
            value = context != null ? context.rootPath : "";
        } else if (key.equals("FITNESSE_VERSION")) {
            value = new FitNesseVersion().toString();
        } else {
            return Maybe.noString;
        }
        return new Maybe((Object)value);
    }

    public boolean inCache(SourcePage page) {
        return this.cache.containsKey(page.getFullName());
    }

    public Maybe<String> findVariable(SourcePage page, String name) {
        String key = page.getFullName();
        if (!this.cache.containsKey(key)) {
            return Maybe.noString;
        }
        if (!((HashMap)this.cache.get(key)).containsKey(name)) {
            return Maybe.noString;
        }
        return (Maybe)((HashMap)this.cache.get(key)).get(name);
    }

    public Maybe<String> findVariable(String name) {
        return this.findVariable(this.page, name);
    }

    public void putVariable(SourcePage page, String name, Maybe<String> value) {
        String key = page.getFullName();
        if (!this.cache.containsKey(key)) {
            this.cache.put(key, new HashMap());
        }
        ((HashMap)this.cache.get(key)).put(name, value);
    }

    public void putVariable(String name, String value) {
        this.putVariable(this.page, name, new Maybe((Object)value));
    }

    public String renderVariableValue(String variableValue) {
        return new HtmlTranslator(null, this).translate(Parser.make((ParsingPage)this, (String)"", (SymbolProvider)variableDefinitionSymbolProvider).parseWithParent(variableValue, null));
    }
}

