/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.ParseSpecification;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolMatch;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.parser.WikiWord;
import fitnesse.wikitext.parser.WikiWordPath;
import java.util.regex.Pattern;

public class TextMaker {
    public static final String eMailPattern = "[\\w-_.]+@[\\w-_.]+\\.[\\w-_.]+";
    private VariableSource variableSource;
    private SourcePage sourcePage;

    public TextMaker(VariableSource variableSource, SourcePage sourcePage) {
        this.variableSource = variableSource;
        this.sourcePage = sourcePage;
    }

    public SymbolMatch make(ParseSpecification specification, String text) {
        int length;
        if (specification.matchesFor((SymbolType)WikiWord.symbolType) && (length = new WikiWordPath().findLength(text)) > 0) {
            Symbol wikiWord = new Symbol((SymbolType)new WikiWord(this.sourcePage), text.substring(0, length));
            wikiWord.evaluateVariables(new String[]{"REGRACE_LINK"}, this.variableSource);
            return new SymbolMatch(wikiWord, length);
        }
        if (specification.matchesFor(SymbolType.EMail) && this.isEmailAddress(text)) {
            return new SymbolMatch(SymbolType.EMail, text);
        }
        return new SymbolMatch(SymbolType.Text, text);
    }

    private boolean isEmailAddress(String text) {
        return text.indexOf("@") > 0 && Pattern.matches(eMailPattern, text);
    }
}

