/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import fitnesse.wikitext.test.TestSourcePage;
import fitnesse.wikitext.test.TestVariableSource;
import org.junit.Assert;
import org.junit.Test;

public class IncludeTest {
    @Test
    public void scansIncludes() {
        ParserTestHelper.assertScansTokenType((String)"!include name", (String)"Include", (boolean)true);
    }

    @Test
    public void parsesIncludes() throws Exception {
        ParserTestHelper.assertParses((String)"!include PageTwo\n", (String)"SymbolList[Include[Text, WikiWord, Meta[Text]], Newline]");
        ParserTestHelper.assertParses((String)"|!include PageTwo|\n", (String)"SymbolList[Table[SymbolList[SymbolList[Include[Text, WikiWord, Meta[Text]]]]]]");
        ParserTestHelper.assertParses((String)"!include PageTwo", (String)"SymbolList[Include[Text, WikiWord, Meta[Text]]]");
        ParserTestHelper.assertParses((String)"!include -c PageTwo", (String)"SymbolList[Include[Text, WikiWord, Meta[Text]]]");
        ParserTestHelper.assertParses((String)"!include <PageTwo", (String)"SymbolList[Include[Text, WikiWord, Meta[Text]]]");
        ParserTestHelper.assertParses((String)"!include <PageTwo>", (String)"SymbolList[Include[Text, WikiWord, Meta[Text]], Text]");
        ParserTestHelper.assertParses((String)"!include -setup PageTwo", (String)"SymbolList[Include[Text, WikiWord, Meta[Text]]]");
        ParserTestHelper.assertParses((String)"!include -teardown PageTwo", (String)"SymbolList[Include[Text, WikiWord, Meta[Text]]]");
    }

    @Test
    public void translatesIncludedSibling() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage currentPage = root.makePage("PageOne", "!include PageTwo");
        root.makePage("PageTwo", "page ''two''");
        String result = ParserTestHelper.translateTo((WikiPage)currentPage);
        this.assertContains(result, "class=\"collapsible\"");
        this.assertContains(result, "Included page: <a href=\"PageTwo\">PageTwo</a> <a href=\"PageTwo?edit&amp;redirectToReferer=true&amp;redirectAction=\" class=\"edit\">(edit)</a>");
        this.assertContains(result, "page <i>two</i>");
    }

    @Test
    public void translatesIncludeWithChildReference() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage currentPage = root.makePage("PageOne", "!include PageTwo");
        WikiPage pageTwo = root.makePage("PageTwo", ">PageTwoChild");
        root.makePage(pageTwo, "PageTwoChild", "stuff");
        String result = ParserTestHelper.translateTo((WikiPage)currentPage);
        this.assertContains(result, "PageTwo.PageTwoChild");
    }

    @Test
    public void translatesRelativeInclude() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage currentPage = root.makePage("PageOne", "!include >PageOneChild");
        root.makePage(currentPage, "PageOneChild", "stuff");
        String result = ParserTestHelper.translateTo((WikiPage)currentPage);
        this.assertContains(result, "stuff");
    }

    @Test
    public void translatesNestedRelativeInclude() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage currentPage = root.makePage("PageOne", "!include >PageOneChild");
        WikiPage pageOneChild = root.makePage(currentPage, "PageOneChild", "!include >PageOneGrandChild");
        root.makePage(pageOneChild, "PageOneGrandChild", "stuff");
        String result = ParserTestHelper.translateTo((WikiPage)currentPage);
        this.assertContains(result, "stuff");
    }

    @Test
    public void setupsAreHidden() throws Exception {
        String result = ParserTestHelper.translateTo((SourcePage)this.makePageThatIncludesSetup());
        this.assertContains(result, "class=\"collapsible closed\"");
        this.assertContains(result, "<a href=\"PageTwo.SetUp\">");
    }

    @Test
    public void teardownsAreHidden() throws Exception {
        String result = ParserTestHelper.translateTo((SourcePage)this.makePageThatIncludesTeardown());
        this.assertContains(result, "class=\"collapsible closed\"");
        this.assertContains(result, "<a href=\"PageTwo.TearDown\">");
    }

    private TestSourcePage makePageThatIncludesSetup() {
        return new TestSourcePage().withContent("!include -setup >SetUp").withTarget("PageTwo.SetUp").withIncludedPage((SourcePage)new TestSourcePage().withContent("setup"));
    }

    private TestSourcePage makePageThatIncludesTeardown() {
        return new TestSourcePage().withContent("!include -teardown >TearDown").withTarget("PageTwo.TearDown").withIncludedPage((SourcePage)new TestSourcePage().withContent("teardown"));
    }

    @Test
    public void translatesSetupWithoutCollapse() throws Exception {
        String result = ParserTestHelper.translateTo((SourcePage)this.makePageThatIncludesSetup(), (VariableSource)new TestVariableSource("COLLAPSE_SETUP", "false"));
        this.assertContains(result, "class=\"collapsible\"");
        this.assertContains(result, "<a href=\"PageTwo.SetUp\">");
    }

    @Test
    public void translatesCollapsed() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage includingPage = root.makePage("PageOne", "!include -c PageTwo");
        root.makePage("PageTwo", "two");
        String result = ParserTestHelper.translateTo((WikiPage)includingPage);
        this.assertContains(result, "class=\"collapsible closed\"");
    }

    @Test
    public void translatesSeamless() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage includingPage = root.makePage("PageOne", "!include -seamless PageTwo");
        root.makePage("PageTwo", "two");
        ParserTestHelper.assertTranslatesTo((WikiPage)includingPage, (String)"two");
    }

    @Test
    public void doesNotIncludeParent() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage parent = root.makePage("ParentPage", "stuff");
        WikiPage currentPage = root.makePage(parent, "PageOne", "!include <ParentPage");
        ParserTestHelper.assertTranslatesTo((WikiPage)currentPage, (String)"<span class=\"meta\">Error! Cannot include parent page (&lt;ParentPage).\n</span>");
    }

    @Test
    public void doesNotIncludeInvalidPageNames() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage parent = root.makePage("ParentPage", "stuff");
        WikiPage currentPage = root.makePage(parent, "PageOne", "!include not.a.wiki.page");
        ParserTestHelper.assertTranslatesTo((WikiPage)currentPage, (String)"<span class=\"meta\">Page include failed because the page not.a.wiki.page does not have a valid WikiPage name.\n</span>");
    }

    private void assertContains(String result, String substring) {
        Assert.assertTrue((String)result, (boolean)result.contains(substring));
    }
}

