/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestSourcePage;
import java.util.GregorianCalendar;
import org.junit.Test;
import util.SystemTimeKeeper;
import util.TestTimeKeeper;

public class LastModifiedTest {
    @Test
    public void scansLastModified() {
        ParserTestHelper.assertScansTokenType((String)"!lastmodified", (String)"LastModified", (boolean)true);
    }

    @Test
    public void translatesLastModified() throws Exception {
        TestSourcePage page = this.makeTestPageWithDate("20010203040506");
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)ParserTestHelper.metaHtml((String)"Last modified anonymously on Feb 03, 2001 at 04:05:06 AM"));
    }

    @Test
    public void translatesWithUser() throws Exception {
        TestSourcePage page = this.makeTestPageWithDate("20010203040506").withProperty("LastModifyingUser", "bob");
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)ParserTestHelper.metaHtml((String)"Last modified by bob on Feb 03, 2001 at 04:05:06 AM"));
    }

    @Test
    public void usesNowIfNoDate() throws Exception {
        SystemTimeKeeper.instance = new TestTimeKeeper(new GregorianCalendar(2002, 2, 4, 5, 6, 7).getTime());
        TestSourcePage page = this.makeTestPage();
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)ParserTestHelper.metaHtml((String)"Last modified anonymously on Mar 04, 2002 at 05:06:07 AM"));
    }

    @Test
    public void usesDateStringIfInvalid() throws Exception {
        TestSourcePage page = this.makeTestPageWithDate("garbage");
        ParserTestHelper.assertTranslatesTo((SourcePage)page, (String)ParserTestHelper.metaHtml((String)"Last modified anonymously on garbage"));
    }

    private TestSourcePage makeTestPageWithDate(String date) {
        return this.makeTestPage().withProperty("LastModified", date);
    }

    private TestSourcePage makeTestPage() {
        return new TestSourcePage().withContent("!lastmodified");
    }
}

