/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wikitext.test.ParserTestHelper;
import org.junit.Test;

public class LineTest {
    @Test
    public void scansHeaders() {
        ParserTestHelper.assertScansTokenType((String)"!1 some text\n", (String)"HeaderLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!2 \n", (String)"HeaderLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!3 text\n", (String)"HeaderLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!4 text\n", (String)"HeaderLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!5 text\n", (String)"HeaderLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!6 text\n", (String)"HeaderLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!3text\n", (String)"HeaderLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!0 text\n", (String)"HeaderLine", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"!7 text\n", (String)"HeaderLine", (boolean)false);
    }

    @Test
    public void translatesHeaders() {
        for (int i = 1; i < 7; ++i) {
            ParserTestHelper.assertTranslatesTo((String)("!" + i + " some text"), (String)("<h" + i + ">some text</h" + i + ">" + HtmlElement.endl));
        }
        ParserTestHelper.assertTranslatesTo((String)"atstart\n!1 text\n", (String)("atstart<br/><h1>text</h1>" + HtmlElement.endl));
        ParserTestHelper.assertTranslatesTo((String)"|!1 text|\n", (String)ParserTestHelper.tableWithCell((String)"<h1>text</h1>"));
        ParserTestHelper.assertTranslatesTo((String)"| !1 text|\n", (String)ParserTestHelper.tableWithCell((String)"<h1>text</h1>"));
        ParserTestHelper.assertTranslatesTo((String)"|a|!1 text|\n", (String)ParserTestHelper.tableWithCells((String[])new String[]{"a", "<h1>text</h1>"}));
    }

    @Test
    public void doesNotTranslateHeaders() {
        ParserTestHelper.assertTranslatesTo((String)"notstart !1 text\n", (String)"notstart !1 text<br/>");
        ParserTestHelper.assertTranslatesTo((String)"|!1 text\n", (String)"|!1 text<br/>");
    }

    @Test
    public void scansCenters() {
        ParserTestHelper.assertScansTokenType((String)"!c text", (String)"CenterLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!C text", (String)"CenterLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!ctext", (String)"CenterLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)" !c text\n", (String)"CenterLine", (boolean)false);
    }

    @Test
    public void translatesCenters() {
        ParserTestHelper.assertTranslatesTo((String)"!c some text", (String)("<center>some text</center>" + HtmlElement.endl));
    }

    @Test
    public void scansNotes() {
        ParserTestHelper.assertScansTokenType((String)"!note some note\n", (String)"NoteLine", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"! note some note\n", (String)"NoteLine", (boolean)false);
    }

    @Test
    public void translatesNotes() {
        ParserTestHelper.assertTranslatesTo((String)"!note some note", (String)"<p class=\"note\">some note</p>");
    }

    @Test
    public void translatesMetas() {
        ParserTestHelper.assertTranslatesTo((String)"!meta stuff", (String)"<span class=\"meta\">stuff</span>");
    }

    @Test
    public void translatesCombined() {
        ParserTestHelper.assertTranslatesTo((String)"!1 !c stuff", (String)("<h1><center>stuff</center></h1>" + HtmlElement.endl));
        ParserTestHelper.assertTranslatesTo((String)"!1 !c stuff\n", (String)("<h1><center>stuff</center></h1>" + HtmlElement.endl));
        ParserTestHelper.assertTranslatesTo((String)"!1 !c '''stuff'''\n", (String)("<h1><center><b>stuff</b></center></h1>" + HtmlElement.endl));
        ParserTestHelper.assertTranslatesTo((String)"!1 !c stuff\nmore", (String)("<h1><center>stuff</center></h1>" + HtmlElement.endl + "more"));
    }
}

