/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Scanner;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolProvider;
import fitnesse.wikitext.parser.VariableSource;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.parser.WikiTranslator;
import fitnesse.wikitext.test.TestRoot;
import fitnesse.wikitext.test.TestSourcePage;
import org.junit.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParserTestHelper {
    public static final String newLineRendered = "<br/>";

    public static void assertScans(String input, String expected) {
        Scanner scanner = new Scanner((SourcePage)new TestSourcePage(), input);
        ParserTestHelper.assertScans((String)expected, (Scanner)scanner);
    }

    public static void assertScansTokenType(String input, String expected, boolean found) {
        block1: {
            Scanner scanner = new Scanner((SourcePage)new TestSourcePage(), input);
            do {
                scanner.moveNext();
                if (scanner.isEnd()) break block1;
            } while (!scanner.getCurrent().getType().toString().equals(expected));
            Assert.assertTrue((boolean)found);
            return;
        }
        Assert.assertTrue((!found ? 1 : 0) != 0);
    }

    public static void assertScans(String expected, Scanner scanner) {
        StringBuilder result = new StringBuilder();
        while (true) {
            scanner.moveNext();
            if (scanner.isEnd()) break;
            if (result.length() > 0) {
                result.append(",");
            }
            Symbol current = scanner.getCurrent();
            String name = current.getType().toString();
            result.append(name);
            String content = current.getContent();
            if (content.length() <= 0) continue;
            result.append("=").append(content);
        }
        Assert.assertEquals((Object)expected, (Object)result.toString());
    }

    public static void assertTranslatesTo(String input, String expected) {
        ParserTestHelper.assertTranslatesTo((SourcePage)new TestSourcePage(), (String)input, (String)expected);
    }

    public static void assertTranslatesTo(WikiPage page, VariableSource variableSource, String expected) throws Exception {
        Assert.assertEquals((Object)expected, (Object)ParserTestHelper.translateToHtml((WikiPage)page, (String)page.getData().getContent(), (VariableSource)variableSource));
    }

    public static void assertTranslatesTo(String input, VariableSource variableSource, String expected) {
        Assert.assertEquals((Object)expected, (Object)ParserTestHelper.translateToHtml(null, (String)input, (VariableSource)variableSource));
    }

    public static void assertTranslatesTo(WikiPage page, String input, String expected) {
        Assert.assertEquals((Object)expected, (Object)ParserTestHelper.translateTo((WikiPage)page, (String)input));
    }

    public static void assertTranslatesTo(SourcePage page, String input, String expected) {
        Assert.assertEquals((Object)expected, (Object)ParserTestHelper.translateTo((SourcePage)page, (String)input));
        Assert.assertEquals((String)"round trip", (Object)input, (Object)ParserTestHelper.roundTrip((SourcePage)page, (String)input));
    }

    public static void assertTranslatesTo(SourcePage page, String expected) throws Exception {
        Assert.assertEquals((Object)expected, (Object)ParserTestHelper.translateTo((SourcePage)page));
    }

    public static void assertTranslatesTo(WikiPage page, String expected) throws Exception {
        Assert.assertEquals((Object)expected, (Object)ParserTestHelper.translateTo((SourcePage)new WikiSourcePage(page)));
    }

    public static String translateTo(WikiPage page, String input) {
        Symbol list = Parser.make((ParsingPage)new ParsingPage((SourcePage)new WikiSourcePage(page)), (String)input).parse();
        return new HtmlTranslator((SourcePage)new WikiSourcePage(page), new ParsingPage((SourcePage)new WikiSourcePage(page))).translateTree(list);
    }

    public static String translateTo(SourcePage page, String input) {
        Symbol list = Parser.make((ParsingPage)new ParsingPage(page), (String)input).parse();
        return new HtmlTranslator(page, new ParsingPage(page)).translateTree(list);
    }

    public static String roundTrip(SourcePage page, String input) {
        Symbol list = Parser.make((ParsingPage)new ParsingPage(page), (String)input, (SymbolProvider)SymbolProvider.refactoringProvider).parse();
        return new WikiTranslator(page).translateTree(list);
    }

    public static String translateToHtml(WikiPage page, String input, VariableSource variableSource) {
        Symbol list = Parser.make((ParsingPage)new ParsingPage((SourcePage)new WikiSourcePage(page)), (String)input, (VariableSource)variableSource, (SymbolProvider)SymbolProvider.wikiParsingProvider).parse();
        return new HtmlTranslator((SourcePage)new WikiSourcePage(page), new ParsingPage((SourcePage)new WikiSourcePage(page))).translateTree(list);
    }

    public static String translateTo(WikiPage page) throws Exception {
        return ParserTestHelper.translateTo((SourcePage)new WikiSourcePage(page));
    }

    public static String translateTo(SourcePage page, VariableSource variableSource) throws Exception {
        return new HtmlTranslator(page, new ParsingPage(page)).translateTree(Parser.make((ParsingPage)new ParsingPage(page), (String)page.getContent(), (VariableSource)variableSource, (SymbolProvider)SymbolProvider.wikiParsingProvider).parse());
    }

    public static String translateTo(SourcePage page) throws Exception {
        return new HtmlTranslator(page, new ParsingPage(page)).translateTree(Parser.make((ParsingPage)new ParsingPage(page), (String)page.getContent()).parse());
    }

    public static void assertParses(String input, String expected) throws Exception {
        WikiPage page = new TestRoot().makePage("TestPage", input);
        Symbol result = ParserTestHelper.parse((WikiPage)page, (String)input);
        Assert.assertEquals((Object)expected, (Object)ParserTestHelper.serialize((Symbol)result));
    }

    public static Symbol parse(WikiPage page) throws Exception {
        return Parser.make((ParsingPage)new ParsingPage((SourcePage)new WikiSourcePage(page)), (String)page.getData().getContent()).parse();
    }

    public static Symbol parse(WikiPage page, String input) {
        return Parser.make((ParsingPage)new ParsingPage((SourcePage)new WikiSourcePage(page)), (String)input).parse();
    }

    public static String serialize(Symbol symbol) {
        StringBuilder result = new StringBuilder();
        result.append(symbol.getType() != null ? symbol.getType().toString() : "?no type?");
        int i = 0;
        for (Symbol child : symbol.getChildren()) {
            result.append(i == 0 ? "[" : ", ");
            result.append(ParserTestHelper.serialize((Symbol)child));
            ++i;
        }
        if (i > 0) {
            result.append("]");
        }
        return result.toString();
    }

    public static String serializeContent(Symbol symbol) {
        StringBuilder result = new StringBuilder();
        if (symbol.getContent() != null) {
            result.append(symbol.getContent());
        }
        for (Symbol child : symbol.getChildren()) {
            result.append(ParserTestHelper.serializeContent((Symbol)child));
        }
        return result.toString();
    }

    public static String metaHtml(String message) {
        return "<span class=\"meta\">" + message + "</span>";
    }

    public static String tableWithCell(String cellContent) {
        return ParserTestHelper.tableWithCellAndRow((String)cellContent, (String)"<tr>");
    }

    public static String tableWithCells(String[] cellContent) {
        StringBuilder cells = new StringBuilder();
        for (String cell : cellContent) {
            if (cells.length() > 0) {
                cells.append("</td>").append(HtmlElement.endl).append("\t\t<td>");
            }
            cells.append(cell);
        }
        return ParserTestHelper.tableWithCellAndRow((String)cells.toString(), (String)"<tr>");
    }

    public static String tableWithCellAndRow(String cellContent, String firstRow) {
        return ParserTestHelper.nestedTableWithCellAndRow((String)cellContent, (String)firstRow) + HtmlElement.endl;
    }

    public static String nestedTableWithCellAndRow(String cellContent, String firstRow) {
        StringBuilder tableWithCellAndRow = new StringBuilder();
        tableWithCellAndRow.append("<table>").append(HtmlElement.endl).append("\t").append(firstRow).append(HtmlElement.endl).append("\t\t<td>").append(cellContent).append("</td>").append(HtmlElement.endl).append("\t</tr>").append(HtmlElement.endl).append("</table>");
        return tableWithCellAndRow.toString();
    }
}

