/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.html.HtmlElement;
import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.parser.HtmlTranslator;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.Paths;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.parser.WikiSourcePage;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PathTest {
    @Test
    public void scansPaths() {
        ParserTestHelper.assertScansTokenType((String)"!path stuff", (String)"Path", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)" !path stuff", (String)"Path", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"| !path stuff|", (String)"Path", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!note !path stuff", (String)"Path", (boolean)true);
    }

    @Test
    public void translatesPaths() throws Exception {
        ParserTestHelper.assertTranslatesTo((String)"!path stuff", (String)"<span class=\"meta\">classpath: stuff</span>");
        ParserTestHelper.assertTranslatesTo((String)"!path stuff\n", (String)"<span class=\"meta\">classpath: stuff</span><br/>");
    }

    @Test
    public void translatesVariableInPath() throws Exception {
        WikiPage page = new TestRoot().makePage("TestPage", "!define x {stuff}\n!path ${x}y\n");
        ParserTestHelper.assertTranslatesTo((WikiPage)page, (String)("<span class=\"meta\">variable defined: x=stuff</span>" + HtmlElement.endl + "<br/>" + "<span class=\"meta\">classpath: stuffy</span>" + "<br/>"));
    }

    @Test
    public void findsDefinitions() throws Exception {
        WikiPage page = new TestRoot().makePage("TestPage", "!path stuff\n!note and\n!path nonsense");
        List paths = new Paths((Translator)new HtmlTranslator((SourcePage)new WikiSourcePage(page), new ParsingPage((SourcePage)new WikiSourcePage(page)))).getPaths(ParserTestHelper.parse((WikiPage)page));
        Assert.assertEquals((long)2L, (long)paths.size());
        Assert.assertEquals((Object)"stuff", paths.get(0));
        Assert.assertEquals((Object)"nonsense", paths.get(1));
    }
}

