/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.parser.Scanner;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestSourcePage;
import org.junit.Assert;
import org.junit.Test;

public class ScannerTest {
    @Test
    public void copyRestoresState() {
        Scanner scanner = new Scanner((SourcePage)new TestSourcePage(), "stuff");
        Scanner backup = new Scanner(scanner);
        ParserTestHelper.assertScans((String)"Text=stuff", (Scanner)scanner);
        ParserTestHelper.assertScans((String)"", (Scanner)scanner);
        scanner.copy(backup);
        ParserTestHelper.assertScans((String)"Text=stuff", (Scanner)scanner);
    }

    @Test
    public void terminatedLiteralAddsTerminator() {
        Scanner scanner = new Scanner((SourcePage)new TestSourcePage(), "stuff\n");
        scanner.makeLiteral(SymbolType.Newline);
        Assert.assertTrue((boolean)scanner.getCurrent().isType(SymbolType.Newline));
    }

    @Test
    public void unterminatedLiteralAddsEmpty() {
        Scanner scanner = new Scanner((SourcePage)new TestSourcePage(), "stuff");
        scanner.makeLiteral(SymbolType.Newline);
        Assert.assertTrue((boolean)scanner.getCurrent().isType(SymbolType.Empty));
    }
}

