/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wiki.WikiPage;
import fitnesse.wikitext.test.ParserTestHelper;
import fitnesse.wikitext.test.TestRoot;
import org.junit.Test;

public class SeeTest {
    @Test
    public void scansSees() {
        ParserTestHelper.assertScansTokenType((String)"!see Stuff", (String)"See", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!seeStuff", (String)"See", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)" !see Stuff", (String)"See", (boolean)false);
        ParserTestHelper.assertScansTokenType((String)"| !see Stuff|", (String)"See", (boolean)true);
        ParserTestHelper.assertScansTokenType((String)"!note !see Stuff", (String)"See", (boolean)true);
    }

    @Test
    public void parsesSees() throws Exception {
        ParserTestHelper.assertParses((String)"!see SomeStuff", (String)"SymbolList[See[WikiWord]]");
        ParserTestHelper.assertParses((String)"!see ya", (String)"SymbolList[Text, Whitespace, Text]");
    }

    @Test
    public void translatesSees() throws Exception {
        TestRoot root = new TestRoot();
        WikiPage page = root.makePage("PageOne", "!see PageTwo");
        root.makePage("PageTwo", "hi");
        ParserTestHelper.assertTranslatesTo((WikiPage)page, (String)"<b>See: <a href=\"PageTwo\">PageTwo</a></b>");
    }
}

