/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.test;

import fitnesse.wikitext.test.ParserTestHelper;
import java.util.GregorianCalendar;
import org.junit.Test;
import util.SystemTimeKeeper;
import util.TestTimeKeeper;

public class TodayTest {
    @Test
    public void translatesTodays() {
        SystemTimeKeeper.instance = new TestTimeKeeper(new GregorianCalendar(2002, 2, 4, 15, 6, 7).getTime());
        ParserTestHelper.assertTranslatesTo((String)"!today", (String)"04 Mar, 2002");
        ParserTestHelper.assertTranslatesTo((String)"!today -t", (String)"04 Mar, 2002 15:06");
        ParserTestHelper.assertTranslatesTo((String)"!today -xml", (String)"2002-03-04T15:06:07");
        ParserTestHelper.assertTranslatesTo((String)"!today (MMM)", (String)"Mar");
        ParserTestHelper.assertTranslatesTo((String)"!today (dd MMM)", (String)"04 Mar");
        ParserTestHelper.assertTranslatesTo((String)"!today (dd MMM", (String)"!today (dd MMM");
    }

    @Test
    public void translatesWithDayIncrements() {
        SystemTimeKeeper.instance = new TestTimeKeeper(new GregorianCalendar(2002, 2, 4, 15, 6, 7).getTime());
        ParserTestHelper.assertTranslatesTo((String)"!today +5", (String)"09 Mar, 2002");
        ParserTestHelper.assertTranslatesTo((String)"!today +10", (String)"14 Mar, 2002");
        ParserTestHelper.assertTranslatesTo((String)"!today -5", (String)"27 Feb, 2002");
        ParserTestHelper.assertTranslatesTo((String)"!today -5.", (String)"27 Feb, 2002.");
    }

    @Test
    public void translatesWithDayIncrementsAndCustomFormat() {
        SystemTimeKeeper.instance = new TestTimeKeeper(new GregorianCalendar(2002, 2, 4, 15, 6, 7).getTime());
        ParserTestHelper.assertTranslatesTo((String)"!today (ddMMM) +5", (String)"09Mar");
    }

    @Test
    public void translatesInTable() {
        SystemTimeKeeper.instance = new TestTimeKeeper(new GregorianCalendar(2002, 2, 4, 15, 6, 7).getTime());
        ParserTestHelper.assertTranslatesTo((String)"|!today (ddMMM)|\n", (String)ParserTestHelper.tableWithCell((String)"04Mar"));
        ParserTestHelper.assertTranslatesTo((String)"|!today -t|\n", (String)ParserTestHelper.tableWithCell((String)"04 Mar, 2002 15:06"));
    }
}

