/*
 * Decompiled with CFR 0.152.
 */
package fitnesseMain;

import fitnesse.Arguments;
import fitnesseMain.FitNesseMain;
import org.junit.Assert;
import org.junit.Test;

public class ArgumentsTest {
    private Arguments args;

    @Test
    public void testSimpleCommandline() throws Exception {
        this.args = this.makeArgs(new String[0]);
        Assert.assertNotNull((Object)this.args);
        Assert.assertEquals((long)80L, (long)this.args.getPort());
        Assert.assertEquals((Object)".", (Object)this.args.getRootPath());
    }

    private Arguments makeArgs(String ... argArray) {
        this.args = FitNesseMain.parseCommandLine((String[])argArray);
        return this.args;
    }

    @Test
    public void testArgumentsDefaults() throws Exception {
        this.makeArgs(new String[0]);
        Assert.assertEquals((long)80L, (long)this.args.getPort());
        Assert.assertEquals((Object)".", (Object)this.args.getRootPath());
        Assert.assertEquals((Object)"FitNesseRoot", (Object)this.args.getRootDirectory());
        Assert.assertEquals(null, (Object)this.args.getLogDirectory());
        Assert.assertEquals((Object)false, (Object)this.args.isOmittingUpdates());
        Assert.assertEquals((long)14L, (long)this.args.getDaysTillVersionsExpire());
        Assert.assertEquals(null, (Object)this.args.getUserpass());
        Assert.assertEquals((Object)false, (Object)this.args.isInstallOnly());
        Assert.assertNull((Object)this.args.getCommand());
    }

    @Test
    public void testArgumentsAlternates() throws Exception {
        String argString = "-p 123 -d MyWd -r MyRoot -l LogDir -e 321 -o -a userpass.txt -i";
        this.makeArgs(argString.split(" "));
        Assert.assertEquals((long)123L, (long)this.args.getPort());
        Assert.assertEquals((Object)"MyWd", (Object)this.args.getRootPath());
        Assert.assertEquals((Object)"MyRoot", (Object)this.args.getRootDirectory());
        Assert.assertEquals((Object)"LogDir", (Object)this.args.getLogDirectory());
        Assert.assertEquals((Object)true, (Object)this.args.isOmittingUpdates());
        Assert.assertEquals((long)321L, (long)this.args.getDaysTillVersionsExpire());
        Assert.assertEquals((Object)"userpass.txt", (Object)this.args.getUserpass());
        Assert.assertEquals((Object)true, (Object)this.args.isInstallOnly());
    }

    @Test
    public void testAllArguments() throws Exception {
        this.args = this.makeArgs(new String[]{"-p", "81", "-d", "directory", "-r", "root", "-l", "myLogDirectory", "-o", "-e", "22"});
        Assert.assertNotNull((Object)this.args);
        Assert.assertEquals((long)81L, (long)this.args.getPort());
        Assert.assertEquals((Object)"directory", (Object)this.args.getRootPath());
        Assert.assertEquals((Object)"root", (Object)this.args.getRootDirectory());
        Assert.assertEquals((Object)"myLogDirectory", (Object)this.args.getLogDirectory());
        Assert.assertTrue((boolean)this.args.isOmittingUpdates());
        Assert.assertEquals((long)22L, (long)this.args.getDaysTillVersionsExpire());
    }

    @Test
    public void testNotOmitUpdates() throws Exception {
        this.args = this.makeArgs(new String[]{"-p", "81", "-d", "directory", "-r", "root", "-l", "myLogDirectory"});
        Assert.assertNotNull((Object)this.args);
        Assert.assertEquals((long)81L, (long)this.args.getPort());
        Assert.assertEquals((Object)"directory", (Object)this.args.getRootPath());
        Assert.assertEquals((Object)"root", (Object)this.args.getRootDirectory());
        Assert.assertEquals((Object)"myLogDirectory", (Object)this.args.getLogDirectory());
        Assert.assertFalse((boolean)this.args.isOmittingUpdates());
    }

    @Test
    public void commandShouldUseDifferentDefaultPort() throws Exception {
        this.args = this.makeArgs(new String[]{"-c", "someCommand"});
        Assert.assertNotNull((Object)this.args);
        Assert.assertEquals((long)9123L, (long)this.args.getPort());
    }

    @Test
    public void commandShouldAllowPortToBeSet() throws Exception {
        this.args = this.makeArgs(new String[]{"-c", "someCommand", "-p", "666"});
        Assert.assertNotNull((Object)this.args);
        Assert.assertEquals((long)666L, (long)this.args.getPort());
    }

    @Test
    public void testBadArgument() throws Exception {
        this.args = this.makeArgs(new String[]{"-x"});
        Assert.assertNull((Object)this.args);
    }
}

