/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.internal.AssumptionViolatedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Assume {
    public static void assumeTrue(boolean b) {
        Assume.assumeThat((Object)b, (Matcher)CoreMatchers.is((Object)true));
    }

    public static void assumeFalse(boolean b) {
        Assume.assumeTrue((!b ? 1 : 0) != 0);
    }

    public static void assumeTrue(String message, boolean b) {
        if (!b) {
            throw new AssumptionViolatedException(message);
        }
    }

    public static void assumeFalse(String message, boolean b) {
        Assume.assumeTrue((String)message, (!b ? 1 : 0) != 0);
    }

    public static void assumeNotNull(Object ... objects) {
        Assume.assumeThat(Arrays.asList(objects), (Matcher)CoreMatchers.everyItem((Matcher)CoreMatchers.notNullValue()));
    }

    public static <T> void assumeThat(T actual, Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            throw new AssumptionViolatedException(actual, matcher);
        }
    }

    public static <T> void assumeThat(String message, T actual, Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            throw new AssumptionViolatedException(message, actual, matcher);
        }
    }

    public static void assumeNoException(Throwable t) {
        Assume.assumeThat((Object)t, (Matcher)CoreMatchers.nullValue());
    }

    public static void assumeNoException(String message, Throwable t) {
        Assume.assumeThat((String)message, (Object)t, (Matcher)CoreMatchers.nullValue());
    }
}

