/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import junit.framework.Test;
import junit.runner.Version;
import org.junit.internal.JUnitSystem;
import org.junit.internal.RealSystem;
import org.junit.internal.TextListener;
import org.junit.internal.runners.JUnit38ClassRunner;
import org.junit.runner.Computer;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class JUnitCore {
    private final RunNotifier fNotifier = new RunNotifier();

    public static void main(String ... args) {
        JUnitCore.runMainAndExit((JUnitSystem)new RealSystem(), (String[])args);
    }

    private static void runMainAndExit(JUnitSystem system, String ... args) {
        Result result = new JUnitCore().runMain(system, args);
        System.exit(result.wasSuccessful() ? 0 : 1);
    }

    public static Result runClasses(Computer computer, Class<?> ... classes) {
        return new JUnitCore().run(computer, (Class[])classes);
    }

    public static Result runClasses(Class<?> ... classes) {
        return new JUnitCore().run(JUnitCore.defaultComputer(), (Class[])classes);
    }

    private Result runMain(JUnitSystem system, String ... args) {
        system.out().println("JUnit version " + Version.id());
        ArrayList classes = new ArrayList();
        ArrayList<Failure> missingClasses = new ArrayList<Failure>();
        for (String string : args) {
            try {
                classes.add(Class.forName(string));
            }
            catch (ClassNotFoundException e) {
                system.out().println("Could not find class: " + string);
                Description description = Description.createSuiteDescription((String)string, (Annotation[])new Annotation[0]);
                Failure failure = new Failure(description, (Throwable)e);
                missingClasses.add(failure);
            }
        }
        TextListener listener = new TextListener(system);
        this.addListener((RunListener)listener);
        Result result = this.run(classes.toArray(new Class[0]));
        for (Failure failure : missingClasses) {
            result.getFailures().add(failure);
        }
        return result;
    }

    public String getVersion() {
        return Version.id();
    }

    public Result run(Class<?> ... classes) {
        return this.run(Request.classes((Computer)JUnitCore.defaultComputer(), (Class[])classes));
    }

    public Result run(Computer computer, Class<?> ... classes) {
        return this.run(Request.classes((Computer)computer, (Class[])classes));
    }

    public Result run(Request request) {
        return this.run(request.getRunner());
    }

    public Result run(Test test) {
        return this.run((Runner)new JUnit38ClassRunner(test));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result run(Runner runner) {
        Result result = new Result();
        RunListener listener = result.createListener();
        this.fNotifier.addFirstListener(listener);
        try {
            this.fNotifier.fireTestRunStarted(runner.getDescription());
            runner.run(this.fNotifier);
            this.fNotifier.fireTestRunFinished(result);
        }
        finally {
            this.removeListener(listener);
        }
        return result;
    }

    public void addListener(RunListener listener) {
        this.fNotifier.addListener(listener);
    }

    public void removeListener(RunListener listener) {
        this.fNotifier.removeListener(listener);
    }

    static Computer defaultComputer() {
        return new Computer();
    }
}

