/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.util.Arrays;
import java.util.List;
import jdepend.framework.JavaPackage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.scijava.maven.plugin.enforcer.PackageCycleCollector;

public class PackageCycleCollectorTest {
    private JavaPackage packageA;
    private JavaPackage packageB;
    private JavaPackage packageC;
    private JavaPackage packageD;
    private JavaPackage packageE;
    private PackageCycleCollector collector;
    private List<JavaPackage> packages;

    @Before
    public void setUp() {
        this.packageA = new JavaPackage("packageA");
        this.packageB = new JavaPackage("packageB");
        this.packageC = new JavaPackage("packageC");
        this.packageD = new JavaPackage("packageD");
        this.packageE = new JavaPackage("packageE");
        this.packages = Arrays.asList(this.packageA, this.packageB, this.packageC, this.packageD, this.packageE);
        this.collector = new PackageCycleCollector();
    }

    @Test
    public void collectCycles_NoCycle() throws Exception {
        this.packageA.dependsUpon(new JavaPackage[]{this.packageB});
        this.assertCyclesWith(this.packageA, new JavaPackage[0]);
    }

    @Test
    public void collectCycles_HasCycle() throws Exception {
        this.packageA.dependsUpon(new JavaPackage[]{this.packageB});
        this.packageB.dependsUpon(new JavaPackage[]{this.packageA});
        this.assertCyclesWith(this.packageA, this.packageA, this.packageB);
    }

    @Test
    public void collectCycles_HasCycleWithThreePackages() throws Exception {
        this.packageA.dependsUpon(new JavaPackage[]{this.packageB});
        this.packageB.dependsUpon(new JavaPackage[]{this.packageC});
        this.packageC.dependsUpon(new JavaPackage[]{this.packageA});
        this.assertCyclesWith(this.packageA, this.packageA, this.packageB, this.packageC);
    }

    @Test
    public void collectCycles_HasCycleWithMultiplePaths() throws Exception {
        this.packageA.dependsUpon(new JavaPackage[]{this.packageB});
        this.packageB.dependsUpon(new JavaPackage[]{this.packageC});
        this.packageC.dependsUpon(new JavaPackage[]{this.packageA});
        this.packageD.dependsUpon(new JavaPackage[]{this.packageB});
        this.packageB.dependsUpon(new JavaPackage[]{this.packageD});
        this.packageB.dependsUpon(new JavaPackage[]{this.packageE});
        this.packageE.dependsUpon(new JavaPackage[]{this.packageC});
        this.assertCyclesWith(this.packageA, this.packageA, this.packageB, this.packageC, this.packageD, this.packageE);
    }

    @Test
    public void collectCycles_HasCycleWithDependendPackageNotInCycle() throws Exception {
        this.packageA.dependsUpon(new JavaPackage[]{this.packageB});
        this.packageB.dependsUpon(new JavaPackage[]{this.packageA});
        this.packageC.dependsUpon(new JavaPackage[]{this.packageA});
        this.assertCyclesWith(this.packageC, this.packageA, this.packageB);
    }

    private void assertCyclesWith(JavaPackage rootPackage, JavaPackage ... javaPackages) {
        if (javaPackages.length == 0) {
            MatcherAssert.assertThat((Object)this.collector.collectCycles(this.packages), (Matcher)Matchers.is((Matcher)Matchers.empty()));
            return;
        }
        MatcherAssert.assertThat((Object)this.collector.collectCycles(this.packages), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(this.collector.collectCycles(this.packages).get(0), (Matcher)Matchers.containsInAnyOrder((Object[])javaPackages));
    }
}

