/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.enforcer;

import java.util.ArrayList;
import java.util.List;
import jdepend.framework.JavaClass;
import jdepend.framework.JavaPackage;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.scijava.maven.plugin.enforcer.CollectionOutput;
import org.scijava.maven.plugin.enforcer.PackageCycleOutput;

public class PackageCycleOutputTest {
    private static final String PACKAGE1_CLASS_NAME1 = "Package1Class1";
    private static final String PACKAGE1_CLASS_NAME2 = "Package1Class2";
    private static final String PACKAGE2_CLASS_NAME = "Package2Class";
    private static final String PACKAGE1_NAME = "sample.package1";
    private static final String PACKAGE2_NAME = "sample.package2";
    private List<JavaPackage> packages;
    private JavaPackage package1;
    private JavaPackage package2;

    @Before
    public void setUp() {
        this.packages = new ArrayList<JavaPackage>();
        this.initDefaultPackages();
        this.package1.dependsUpon(new JavaPackage[]{this.package2});
        this.package2.dependsUpon(new JavaPackage[]{this.package1});
    }

    @Test
    public void outputFor_TwoPackagesWithCycleButNoClasses() throws Exception {
        this.assertOutput(this.getPackageCycleOutput(this.package1, this.package2) + this.getPackageOutput(this.package1) + this.getPackageOutput(this.package2));
    }

    @Test
    public void outputFor_TwoPackagesWithCycleAndClasses() throws Exception {
        JavaClass package1Class = this.createClassInPackage(PACKAGE1_CLASS_NAME1, this.package1);
        package1Class.addImportedPackage(this.package2);
        JavaClass package2Class = this.createClassInPackage(PACKAGE2_CLASS_NAME, this.package2);
        package2Class.addImportedPackage(this.package1);
        this.assertOutput(this.getPackageCycleOutput(this.package1, this.package2) + this.getPackageOutputWithClasses(this.package1, this.package2, PACKAGE1_CLASS_NAME1) + this.getPackageOutputWithClasses(this.package2, this.package1, PACKAGE2_CLASS_NAME));
    }

    @Test
    public void outputFor_TwoPackagesWithCycle_AndOnePackageWithoutCycle() throws Exception {
        String packageWithoutCycleName = "sample.package.without.cycle";
        this.createPackage(packageWithoutCycleName);
        this.assertOutput(this.getPackageCycleOutput(this.package1, this.package2) + this.getPackageOutput(this.package1) + this.getPackageOutput(this.package2));
    }

    @Test
    public void outputFor_TwoPackagesWithCycle_AndOnePackageWithoutCycle_DependingOnAnotherPackage() throws Exception {
        String packageWithoutCycleName = "sample.package.without.cycle";
        JavaPackage packageWithoutCycle = this.createPackage(packageWithoutCycleName);
        packageWithoutCycle.dependsUpon(new JavaPackage[]{this.package1});
        this.assertOutput(this.getPackageCycleOutput(this.package1, this.package2) + this.getPackageOutput(this.package1) + this.getPackageOutput(this.package2));
    }

    @Test
    public void outputFor_ThreePackagesWithCycle() throws Exception {
        String package3Name = "sample.package3";
        JavaPackage package3 = this.createPackage(package3Name);
        this.package1.dependsUpon(new JavaPackage[]{package3});
        package3.dependsUpon(new JavaPackage[]{this.package1});
        this.assertOutput(this.getPackageCycleOutput(this.package1, this.package2, package3) + this.getPackageOutput(this.package1) + this.getPackageOutput(this.package2) + this.getPackageOutput(package3));
    }

    @Test
    public void outputFor_PackageWithCycleAndMultipleClasses() throws Exception {
        JavaClass package1Class1 = this.createClassInPackage(PACKAGE1_CLASS_NAME1, this.package1);
        package1Class1.addImportedPackage(this.package2);
        JavaClass package1Class2 = this.createClassInPackage(PACKAGE1_CLASS_NAME2, this.package1);
        package1Class2.addImportedPackage(this.package2);
        this.assertOutput(this.getPackageCycleOutput(this.package1, this.package2) + this.getPackageOutputWithClasses(this.package1, this.package2, PACKAGE1_CLASS_NAME1, PACKAGE1_CLASS_NAME2) + this.getPackageOutput(this.package2));
    }

    @Test
    public void outputFor_PackageWithCycleAndClassWithoutCycle() throws Exception {
        JavaClass package1Class1 = this.createClassInPackage(PACKAGE1_CLASS_NAME1, this.package1);
        package1Class1.addImportedPackage(this.package2);
        this.createClassInPackage(PACKAGE1_CLASS_NAME2, this.package1);
        this.assertOutput(this.getPackageCycleOutput(this.package1, this.package2) + this.getPackageOutputWithClasses(this.package1, this.package2, PACKAGE1_CLASS_NAME1) + this.getPackageOutput(this.package2));
    }

    @Test
    public void outputFor_MultiplePackageCycles_IsOrderedByName() {
        JavaPackage otherPackage1 = this.createPackage("other.package1");
        JavaPackage otherPackage2 = this.createPackage("other.package2");
        otherPackage1.dependsUpon(new JavaPackage[]{otherPackage2});
        otherPackage2.dependsUpon(new JavaPackage[]{otherPackage1});
        this.assertOutput(this.getPackageCycleOutput(otherPackage1, otherPackage2) + this.getPackageOutput(otherPackage1) + this.getPackageOutput(otherPackage2) + this.getPackageCycleOutput(this.package1, this.package2) + this.getPackageOutput(this.package1) + this.getPackageOutput(this.package2));
    }

    @Test
    public void outputFor_MultiplePackageCycles_IsOrderedByCycle() {
        this.initDefaultPackages();
        JavaPackage otherPackage1 = this.createPackage("other.package1");
        JavaPackage otherPackage2 = this.createPackage("other.package2");
        this.package1.dependsUpon(new JavaPackage[]{otherPackage1});
        otherPackage1.dependsUpon(new JavaPackage[]{this.package1});
        this.package2.dependsUpon(new JavaPackage[]{otherPackage2});
        otherPackage2.dependsUpon(new JavaPackage[]{this.package2});
        this.assertOutput(this.getPackageCycleOutput(otherPackage1, this.package1) + this.getPackageOutput(otherPackage1) + this.getPackageOutput(this.package1) + this.getPackageCycleOutput(otherPackage2, this.package2) + this.getPackageOutput(otherPackage2) + this.getPackageOutput(this.package2));
    }

    @Test
    public void outputFor_ClassesInPackageNamesWithDifferentLengths() throws Exception {
        this.initDefaultPackages();
        JavaPackage otherPackage1 = this.createPackage("other.package1");
        this.package1.dependsUpon(new JavaPackage[]{otherPackage1});
        otherPackage1.dependsUpon(new JavaPackage[]{this.package1});
        JavaClass package1Class = this.createClassInPackage(PACKAGE1_CLASS_NAME1, this.package1);
        package1Class.addImportedPackage(otherPackage1);
        this.assertOutput(this.getPackageCycleOutput(otherPackage1, this.package1) + this.getPackageOutput(otherPackage1) + this.getPackageOutputWithClasses(this.package1, otherPackage1, PACKAGE1_CLASS_NAME1));
    }

    private JavaPackage createPackage(String package1Name) {
        JavaPackage newPackage = new JavaPackage(package1Name);
        this.packages.add(newPackage);
        return newPackage;
    }

    private void initDefaultPackages() {
        this.packages.clear();
        this.package1 = this.createPackage(PACKAGE1_NAME);
        this.package2 = this.createPackage(PACKAGE2_NAME);
    }

    private JavaClass createClassInPackage(String className, JavaPackage classPackage) {
        JavaClass javaClass = new JavaClass(classPackage.getName() + "." + className);
        javaClass.setPackageName(classPackage.getName());
        classPackage.addClass(javaClass);
        return javaClass;
    }

    private String getPackageOutputWithClasses(JavaPackage javaPackage, JavaPackage dependencyPackage, String ... classNames) {
        String joinedClassNames = CollectionOutput.joinArray((Object[])classNames, (CollectionOutput.StringProvider)new CollectionOutput.StringProvider<String>(){

            public String provide(String value) {
                return value;
            }
        }, (String)", ");
        return this.getPackageOutput(javaPackage.getName()) + this.getDependencyPackageOutput(dependencyPackage.getName(), joinedClassNames);
    }

    private String getPackageOutput(JavaPackage javaPackage) {
        return this.getPackageOutput(javaPackage.getName());
    }

    private String getPackageCycleOutput(JavaPackage ... packages) {
        return "\n\nPackage-cycle found involving " + CollectionOutput.joinArray((Object[])packages, (CollectionOutput.StringProvider)new CollectionOutput.StringProvider<JavaPackage>(){

            public String provide(JavaPackage value) {
                return value.getName();
            }
        }, (String)", ") + ":";
    }

    private void assertOutput(String output) {
        MatcherAssert.assertThat((Object)new PackageCycleOutput(this.packages).getOutput(), (Matcher)Matchers.is((Object)output));
    }

    private String getPackageOutput(String packageName) {
        return "\n    " + packageName + " depends on:";
    }

    private String getDependencyPackageOutput(String dependencyPackageNames, String classNames) {
        return "\n        " + dependencyPackageNames + " (" + classNames + ")";
    }
}

