/*
 * Decompiled with CFR 0.152.
 */
package util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import util.Clock;
import util.SystemClock;

public class ClockTest {
    @After
    public void restoreSystemClock() {
        Clock.restoreDefaultClock();
    }

    @Test
    public void systemClockTimeInMillisShouldIncreaseAsTimeFlies() throws Exception {
        SystemClock clock = new SystemClock();
        long currentTime = 0L;
        long priorTime = 0L;
        while (currentTime == priorTime) {
            currentTime = Clock.currentTimeInMillis();
            if (priorTime != 0L) continue;
            priorTime = currentTime;
        }
    }

    @Test
    public void staticTimeMethodShouldDelegateToInstance() throws Exception {
        this.newConstantTimeClock(1L, true);
        Assert.assertThat((Object)Clock.currentTimeInMillis(), (Matcher)CoreMatchers.is((Object)1L));
    }

    private Clock newConstantTimeClock(long theConstantTime, boolean overrideGlobalClock) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test
    public void dateMethodShouldDelegateToCurrentTimeInMillis() throws Exception {
        Clock constantTimeClock = this.newConstantTimeClock(2L, false);
        Assert.assertThat((Object)constantTimeClock.currentClockDate().getTime(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void staticDateMethodShouldDelegateToInstance() throws Exception {
        this.newConstantTimeClock(3L, true);
        Assert.assertThat((Object)Clock.currentDate().getTime(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void booleanConstructorArgShouldDetermineWhetherToReplaceGlobalInstance() throws Exception {
        Clock constantTimeClock = this.newConstantTimeClock(4L, false);
        Assert.assertThat((Object)Clock.instance, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)constantTimeClock)));
        constantTimeClock = this.newConstantTimeClock(5L, true);
        Assert.assertThat((Object)Clock.instance, (Matcher)CoreMatchers.is((Object)constantTimeClock));
    }

    @Test
    public void shouldBeAbleToRestoreDefaultClock() throws Exception {
        long before = Clock.currentTimeInMillis();
        this.newConstantTimeClock(0L, true);
        Clock.restoreDefaultClock();
        Assert.assertThat((Object)Clock.currentTimeInMillis(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0L)));
        Assert.assertTrue((Clock.currentTimeInMillis() - before < 1000L ? 1 : 0) != 0);
    }
}

