/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Date;
import util.Clock;

public class DateAlteringClock
extends Clock {
    private long rebaseToTime;
    private final long baseSystemTime;
    private boolean frozen;
    private boolean advanceOnEachQuery;

    public DateAlteringClock(Date rebaseToDate) {
        super(true);
        this.rebaseToTime = rebaseToDate.getTime();
        this.baseSystemTime = SYSTEM_CLOCK.currentClockTimeInMillis();
    }

    public long currentClockTimeInMillis() {
        if (this.frozen) {
            return this.rebaseToTime;
        }
        if (this.advanceOnEachQuery) {
            return ++this.rebaseToTime;
        }
        return this.rebaseToTime + SYSTEM_CLOCK.currentClockTimeInMillis() - this.baseSystemTime;
    }

    public DateAlteringClock freeze() {
        this.frozen = true;
        return this;
    }

    public DateAlteringClock advanceMillisOnEachQuery() {
        this.advanceOnEachQuery = true;
        return this;
    }
}

