/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Date;
import util.Clock;

public class TimeMeasurement {
    private final Clock clock;
    private Long startedAt;
    private Long stoppedAt;

    public TimeMeasurement() {
        this(Clock.instance);
    }

    public TimeMeasurement(Clock measuringClock) {
        this.clock = measuringClock;
    }

    public TimeMeasurement start() {
        this.startedAt = this.currentClockTimeInMillis();
        this.stoppedAt = null;
        return this;
    }

    private long currentClockTimeInMillis() {
        return this.clock.currentClockTimeInMillis();
    }

    public long startedAt() {
        if (this.isStarted()) {
            return this.startedAt;
        }
        throw new IllegalStateException("Call start() before getting startedAt()!");
    }

    private boolean isStarted() {
        return this.startedAt != null;
    }

    public long elapsed() {
        if (this.isStopped()) {
            return this.stoppedAt() - this.startedAt();
        }
        return this.currentClockTimeInMillis() - this.startedAt();
    }

    private boolean isStopped() {
        return this.stoppedAt != null;
    }

    public TimeMeasurement stop() {
        if (!this.isStopped()) {
            this.stoppedAt = this.currentClockTimeInMillis();
        }
        return this;
    }

    public long stoppedAt() {
        if (this.isStopped()) {
            return this.stoppedAt;
        }
        throw new IllegalStateException("Call stop() before getting stoppedAt()!");
    }

    public Date startedAtDate() {
        return new Date(this.startedAt());
    }

    public Date stoppedAtDate() {
        return new Date(this.stoppedAt());
    }

    public double elapsedSeconds() {
        return (double)this.elapsed() / 1000.0;
    }
}

