/*
 * Decompiled with CFR 0.152.
 */
package util;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import util.Clock;
import util.DateAlteringClock;
import util.SystemClock;
import util.TimeMeasurement;

public class TimeMeasurementTest {
    private Clock mockedClock;

    @Before
    public void mockClock() {
        this.mockedClock = (Clock)Mockito.mock(SystemClock.class);
    }

    @After
    public void restoreDefaultClock() {
        Clock.restoreDefaultClock();
    }

    @Test
    public void timeMeasurementShouldStartAtClockTime() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement(this.mockedClock);
        Mockito.when((Object)this.mockedClock.currentClockTimeInMillis()).thenReturn((Object)-2L);
        measurement.start();
        Assert.assertThat((Object)measurement.startedAt(), (Matcher)CoreMatchers.is((Object)-2L));
    }

    @Test
    public void elapsedTimeShouldReferenceClockTimeWhenNotStopped() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement(this.mockedClock);
        Mockito.when((Object)this.mockedClock.currentClockTimeInMillis()).thenReturn((Object)-3L, (Object[])new Long[]{-1L});
        measurement.start();
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)2L));
    }

    @Test
    public void stopShouldReferenceClockTime() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement(this.mockedClock);
        Mockito.when((Object)this.mockedClock.currentClockTimeInMillis()).thenReturn((Object)-7L, (Object[])new Long[]{-4L});
        measurement.start();
        measurement.stop();
        Assert.assertThat((Object)measurement.stoppedAt(), (Matcher)CoreMatchers.is((Object)-4L));
    }

    @Test
    public void stopShouldFreezeElapsedTime() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement(this.mockedClock);
        Mockito.when((Object)this.mockedClock.currentClockTimeInMillis()).thenReturn((Object)-9L, (Object[])new Long[]{-8L, -6L});
        measurement.start();
        measurement.stop();
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)1L));
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test(expected=IllegalStateException.class)
    public void startedAtBeforeStartShouldThrowIllegalStateException() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement();
        measurement.startedAt();
    }

    @Test(expected=IllegalStateException.class)
    public void stoppedAtBeforeStopShouldThrowIllegalStateException() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement();
        measurement.start();
        measurement.stoppedAt();
    }

    @Test
    public void callingStopMultipleTimesShouldHaveNoEffect() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement(this.mockedClock);
        Mockito.when((Object)this.mockedClock.currentClockTimeInMillis()).thenReturn((Object)-13L, (Object[])new Long[]{-12L, -11L});
        measurement.start();
        measurement.stop();
        measurement.stop();
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void stopStartShouldResetTheStartedAndStoppedAtTimes() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement(this.mockedClock);
        Mockito.when((Object)this.mockedClock.currentClockTimeInMillis()).thenReturn((Object)-17L, (Object[])new Long[]{-16L, -15L, -14L});
        measurement.start();
        Assert.assertThat((Object)measurement.startedAt(), (Matcher)CoreMatchers.is((Object)-17L));
        measurement.stop();
        Assert.assertThat((Object)measurement.stoppedAt(), (Matcher)CoreMatchers.is((Object)-16L));
        measurement.start();
        Assert.assertThat((Object)measurement.startedAt(), (Matcher)CoreMatchers.is((Object)-15L));
        measurement.stop();
        Assert.assertThat((Object)measurement.stoppedAt(), (Matcher)CoreMatchers.is((Object)-14L));
    }

    @Test
    public void stopStartShouldAffectElapsedTimeCalculations() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement(this.mockedClock);
        Mockito.when((Object)this.mockedClock.currentClockTimeInMillis()).thenReturn((Object)-25L, (Object[])new Long[]{-24L, -23L, -21L, -21L, -19L, -18L});
        measurement.start();
        measurement.stop();
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)1L));
        measurement.start();
        measurement.stop();
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)2L));
        measurement.start();
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)2L));
        measurement.stop();
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void callingStartMultipleTimesShouldResetStartedAtAndElapsed() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement(this.mockedClock);
        Mockito.when((Object)this.mockedClock.currentClockTimeInMillis()).thenReturn((Object)-30L, (Object[])new Long[]{-29L, -29L, -28L, -27L});
        measurement.start();
        Assert.assertThat((Object)measurement.startedAt(), (Matcher)CoreMatchers.is((Object)-30L));
        measurement.start();
        Assert.assertThat((Object)measurement.startedAt(), (Matcher)CoreMatchers.is((Object)-29L));
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)0L));
        measurement.start();
        Assert.assertThat((Object)measurement.startedAt(), (Matcher)CoreMatchers.is((Object)-28L));
        Assert.assertThat((Object)measurement.elapsed(), (Matcher)CoreMatchers.is((Object)1L));
    }

    @Test
    public void startShouldReturnSelfForCallChaining() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement();
        Assert.assertThat((Object)measurement.start(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)measurement)));
    }

    @Test
    public void stopShouldReturnSelfForCallChaining() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement();
        measurement.start();
        Assert.assertThat((Object)measurement.stop(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)measurement)));
    }

    @Test
    public void startedAtDateShouldBeDateRepresentationOfStartedAt() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement();
        Assert.assertThat((Object)measurement.start().startedAtDate().getTime(), (Matcher)CoreMatchers.is((Object)measurement.startedAt()));
    }

    @Test
    public void stoppedAtDateShouldBeDateRepresentationOfStoppedAt() throws Exception {
        TimeMeasurement measurement = new TimeMeasurement();
        measurement.start();
        Assert.assertThat((Object)measurement.stop().stoppedAtDate().getTime(), (Matcher)CoreMatchers.is((Object)measurement.stoppedAt()));
    }

    @Test
    public void elapsedSecondsShouldBeDoubleRepresentationOfElapsed() throws Exception {
        Assert.assertThat((Object)this.timeMeasurementWithElapsedMillis(1L).elapsedSeconds(), (Matcher)CoreMatchers.is((Object)0.001));
        Assert.assertThat((Object)this.timeMeasurementWithElapsedMillis(1000L).elapsedSeconds(), (Matcher)CoreMatchers.is((Object)1.0));
        Assert.assertThat((Object)this.timeMeasurementWithElapsedMillis(2345L).elapsedSeconds(), (Matcher)CoreMatchers.is((Object)2.345));
        Assert.assertThat((Object)this.timeMeasurementWithElapsedMillis(0L).elapsedSeconds(), (Matcher)CoreMatchers.is((Object)0.0));
    }

    private TimeMeasurement timeMeasurementWithElapsedMillis(long millis) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Test
    public void alteringGlobalClockShouldNotAffectExistingTimeMeasurement() throws Exception {
        TimeMeasurement timeMeasurement = new TimeMeasurement();
        new DateAlteringClock(Clock.currentDate()).freeze();
        TimeMeasurement frozentTimeMeasurement = new TimeMeasurement().start();
        timeMeasurement.start();
        SystemClock systemClock = new SystemClock();
        long before = 0L;
        long after = 0L;
        while (before == after) {
            after = systemClock.currentClockTimeInMillis();
            if (before != 0L) continue;
            before = after;
        }
        Assert.assertThat((Object)frozentTimeMeasurement.elapsed(), (Matcher)CoreMatchers.is((Object)0L));
        Assert.assertThat((Object)timeMeasurement.elapsed(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)0L)));
    }
}

