/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import util.FileUtil;
import util.Wildcard;

/*
 * Exception performing whole class analysis ignored.
 */
public class WildcardTest
extends TestCase {
    private File testDir;
    private static final String TEST_DIR = "testDir";

    public void setUp() throws Exception {
        WildcardTest.deleteSampleFiles();
        WildcardTest.makeSampleFiles();
        this.testDir = new File("testDir");
    }

    public void tearDown() throws Exception {
        WildcardTest.deleteSampleFiles();
    }

    public void testJar() throws Exception {
        Wildcard wildcard = new Wildcard("*.jar");
        File[] files = this.testDir.listFiles((FilenameFilter)wildcard);
        List list = this.fileArrayToStringList(files);
        WildcardTest.assertEquals((int)2, (int)files.length);
        WildcardTest.assertTrue((boolean)list.contains("one.jar"));
        WildcardTest.assertTrue((boolean)list.contains("two.jar"));
    }

    public void testDll() throws Exception {
        Wildcard wildcard = new Wildcard("*.dll");
        File[] files = this.testDir.listFiles((FilenameFilter)wildcard);
        List list = this.fileArrayToStringList(files);
        WildcardTest.assertEquals((int)2, (int)files.length);
        WildcardTest.assertTrue((boolean)list.contains("one.dll"));
        WildcardTest.assertTrue((boolean)list.contains("two.dll"));
    }

    public void testOne() throws Exception {
        Wildcard wildcard = new Wildcard("one*");
        File[] files = this.testDir.listFiles((FilenameFilter)wildcard);
        List list = this.fileArrayToStringList(files);
        WildcardTest.assertEquals((int)3, (int)files.length);
        WildcardTest.assertTrue((boolean)list.contains("oneA"));
        WildcardTest.assertTrue((boolean)list.contains("one.jar"));
        WildcardTest.assertTrue((boolean)list.contains("one.dll"));
    }

    public void testAll() throws Exception {
        Wildcard wildcard = new Wildcard("*");
        File[] files = this.testDir.listFiles((FilenameFilter)wildcard);
        WildcardTest.assertEquals((int)6, (int)files.length);
    }

    private List<String> fileArrayToStringList(File[] files) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            list.add(file.getName());
        }
        return list;
    }

    public static void makeSampleFiles() {
        FileUtil.makeDir((String)"testDir");
        FileUtil.createFile((String)"testDir/one.jar", (String)"");
        FileUtil.createFile((String)"testDir/two.jar", (String)"");
        FileUtil.createFile((String)"testDir/one.dll", (String)"");
        FileUtil.createFile((String)"testDir/two.dll", (String)"");
        FileUtil.createFile((String)"testDir/oneA", (String)"");
        FileUtil.createFile((String)"testDir/twoA", (String)"");
    }

    public static void deleteSampleFiles() {
        FileUtil.deleteFileSystemDirectory((String)"testDir");
    }
}

