/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import util.XmlWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public class XmlUtil {
    private static final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();

    public static DocumentBuilder getDocumentBuilder() {
        try {
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document newDocument() {
        return XmlUtil.getDocumentBuilder().newDocument();
    }

    public static Document newDocument(InputStream input) throws IOException, SAXException {
        try {
            return XmlUtil.getDocumentBuilder().parse(input);
        }
        catch (SAXParseException e) {
            throw new SAXException(String.format("SAXParseException at line:%d, col:%d, %s", e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
        }
    }

    public static Document newDocument(File input) throws IOException, SAXException {
        try {
            return XmlUtil.getDocumentBuilder().parse(new InputSource(new InputStreamReader((InputStream)new FileInputStream(input), "UTF-8")));
        }
        catch (SAXParseException e) {
            throw new SAXException(String.format("SAXParseException at line:%d, col:%d, %s", e.getLineNumber(), e.getColumnNumber(), e.getMessage()));
        }
    }

    public static Document newDocument(String input) throws IOException, SAXException {
        ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes("UTF-8"));
        return XmlUtil.newDocument((InputStream)is);
    }

    public static Element getElementByTagName(Element element, String name) {
        NodeList nodes = element.getElementsByTagName(name);
        if (nodes.getLength() == 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    public static Element getLocalElementByTagName(Element context, String tagName) {
        NodeList childNodes = context.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (!(node instanceof Element) || !tagName.equals(node.getNodeName())) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getTextValue(Element element, String name) {
        Element namedElement = XmlUtil.getElementByTagName((Element)element, (String)name);
        return XmlUtil.getElementText((Element)namedElement);
    }

    public static String getLocalTextValue(Element element, String name) {
        Element namedElement = XmlUtil.getLocalElementByTagName((Element)element, (String)name);
        return XmlUtil.getElementText((Element)namedElement);
    }

    public static String getElementText(Element namedElement) {
        if (namedElement == null) {
            return null;
        }
        NodeList nodes = namedElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Text)) continue;
            return node.getNodeValue();
        }
        return null;
    }

    public static void addTextNode(Document document, Element element, String tagName, String value) {
        if (value != null && !value.equals("")) {
            Element titleElement = document.createElement(tagName);
            Text titleText = document.createTextNode(value);
            titleElement.appendChild(titleText);
            element.appendChild(titleElement);
        }
    }

    public static void addCdataNode(Document document, Element element, String tagName, String value) {
        if (value != null && !value.equals("")) {
            Element titleElement = document.createElement(tagName);
            CDATASection cData = document.createCDATASection(value);
            titleElement.appendChild(cData);
            element.appendChild(titleElement);
        }
    }

    public static String xmlAsString(Document doc) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        XmlWriter writer = new XmlWriter((OutputStream)outputStream);
        writer.write(doc);
        writer.flush();
        writer.close();
        String value = outputStream.toString();
        return value;
    }
}

