/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlWriter {
    private static final String endl = System.getProperty("line.separator");
    private Writer writer;
    private boolean isNewLine;

    public XmlWriter(OutputStream os) throws IOException {
        this.writer = new OutputStreamWriter(os, "UTF-8");
    }

    public void write(Document doc) throws IOException {
        this.write("<?xml version=\"1.0\"?>");
        this.write(endl);
        this.write(doc.getDocumentElement(), 0);
    }

    public void write(NodeList nodes) throws Exception {
        this.write(nodes, 0);
    }

    public void write(Element element, int tabs) throws IOException {
        if (!this.isNewLine) {
            this.write(endl);
        }
        if (!element.hasChildNodes()) {
            this.writeTabs(tabs);
            this.write("<" + element.getTagName() + this.writeAttributes(element) + "/>");
        } else {
            this.writeTabs(tabs);
            this.write("<" + element.getTagName() + this.writeAttributes(element) + ">");
            this.write(element.getChildNodes(), tabs + 1);
            if (this.isNewLine) {
                this.writeTabs(tabs);
            }
            this.write("</" + element.getTagName() + ">");
        }
        this.write(endl);
    }

    private String writeAttributes(Element element) {
        StringBuffer attributeString = new StringBuffer();
        NamedNodeMap attributeMap = element.getAttributes();
        int length = attributeMap.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attributeNode = (Attr)attributeMap.item(i);
            String name = attributeNode.getName();
            String value = attributeNode.getValue();
            attributeString.append(" ").append(name).append("=\"").append(value).append("\"");
        }
        return attributeString.toString();
    }

    private void write(NodeList nodes, int tabs) throws IOException {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            this.write(node, tabs);
        }
    }

    private void writeText(Text text) throws IOException {
        String nodeValue = text.getNodeValue();
        this.write(nodeValue.trim());
    }

    private void writeCdata(CDATASection cData) throws IOException {
        String cDataText = "<![CDATA[" + cData.getNodeValue() + "]]>";
        this.write(cDataText);
    }

    private void write(Node node, int tabs) throws IOException {
        if (node instanceof Element) {
            this.write((Element)node, tabs);
        } else if (node instanceof CDATASection) {
            this.writeCdata((CDATASection)node);
        } else if (node instanceof Text) {
            this.writeText((Text)node);
        } else {
            throw new IOException("XmlWriter: unsupported node type: " + node.getClass());
        }
    }

    private void writeTabs(int tabs) throws IOException {
        for (int i = 0; i < tabs; ++i) {
            this.write("\t");
        }
    }

    private void write(String value) throws IOException {
        if (value == null || "".equals(value)) {
            return;
        }
        this.isNewLine = endl.equals(value);
        this.writer.write(value);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }
}

