/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.maven.plugin.dependency.graph.internal;

import java.util.Collection;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.scijava.maven.plugin.dependency.graph.DependencyGraphBuilder;
import org.scijava.maven.plugin.dependency.graph.DependencyGraphBuilderException;
import org.scijava.maven.plugin.dependency.graph.DependencyNode;

@Component(role=DependencyGraphBuilder.class)
public class DefaultDependencyGraphBuilder
extends AbstractLogEnabled
implements DependencyGraphBuilder,
Contextualizable {
    protected PlexusContainer container;

    @Override
    public DependencyNode buildDependencyGraph(MavenProject project, ArtifactFilter filter) throws DependencyGraphBuilderException {
        return this.buildDependencyGraph(project, filter, null);
    }

    @Override
    public DependencyNode buildDependencyGraph(MavenProject project, ArtifactFilter filter, Collection<MavenProject> reactorProjects) throws DependencyGraphBuilderException {
        try {
            String hint = DefaultDependencyGraphBuilder.isMaven31() ? "maven31" : (DefaultDependencyGraphBuilder.isMaven2x() ? "maven2" : "maven3");
            DependencyGraphBuilder effectiveGraphBuilder = (DependencyGraphBuilder)this.container.lookup(DependencyGraphBuilder.class.getCanonicalName(), hint);
            this.getLogger().debug("building " + hint + " dependency graph for " + project.getId() + " with " + effectiveGraphBuilder.getClass().getSimpleName());
            return effectiveGraphBuilder.buildDependencyGraph(project, filter, reactorProjects);
        }
        catch (ComponentLookupException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
    }

    protected static boolean isMaven2x() {
        return !DefaultDependencyGraphBuilder.canFindCoreClass("org.apache.maven.project.DependencyResolutionRequest");
    }

    protected static boolean isMaven31() {
        return DefaultDependencyGraphBuilder.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private static boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

