/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.describe;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Producer;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.describe.BaseDescriptors;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public class BaseDescriptorsTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.byteDescriptor")
    public final Producer<Byte> byteProducer = () -> (byte)0;
    @OpField(names="test.shortDescriptor")
    public final Producer<Short> shortProducer = () -> (short)0;
    @OpField(names="test.intDescriptor")
    public final Producer<Integer> intProducer = () -> 0;
    @OpField(names="test.longDescriptor")
    public final Producer<Long> longProducer = () -> 0L;
    @OpField(names="test.floatDescriptor")
    public final Producer<Float> floatProducer = () -> Float.valueOf(0.0f);
    @OpField(names="test.doubleDescriptor")
    public final Producer<Double> doubleProducer = () -> 0.0;
    @OpField(names="test.listDescriptor")
    public final Producer<List<Double>> listDoubleProducer = ArrayList::new;
    @OpField(names="test.arrayDescriptor")
    public final Producer<double[]> doubleArrayProducer = () -> new double[0];
    @OpField(names="test.arrayArrayDescriptor")
    public final Producer<double[][]> doubleArrayArrayProducer = () -> new double[0][0];
    @OpField(names="test.listArrayDescriptor")
    public final Producer<List<Double[]>> listDoubleArrayProducer = ArrayList::new;
    @OpField(names="test.fooDescriptor")
    public final Producer<Foo> fooProducer = Foo::new;

    @BeforeAll
    public static void addNeededOps() {
        ops.register(new Object[]{new BaseDescriptors()});
        ops.register(new Object[]{new BaseDescriptorsTest()});
    }

    @Test
    public void testBoxedPrimitiveDescriptor() {
        String[] tests;
        for (String t : tests = new String[]{"byte", "short", "int", "long", "float", "double"}) {
            String expected = "test." + t + "Descriptor:\n\t- () -> number";
            String actual = ops.help("test." + t + "Descriptor");
            Assertions.assertEquals((Object)expected, (Object)actual);
        }
    }

    @Test
    public void testListDescriptor() {
        String expected = "test.listDescriptor:\n\t- () -> list<number>";
        String actual = ops.help("test.listDescriptor");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArrayDescriptor() {
        String expected = "test.arrayDescriptor:\n\t- () -> number[]";
        String actual = ops.help("test.arrayDescriptor");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testArrayArrayDescriptor() {
        String expected = "test.arrayArrayDescriptor:\n\t- () -> number[][]";
        String actual = ops.help("test.arrayArrayDescriptor");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testListArrayDescriptor() {
        String expected = "test.listArrayDescriptor:\n\t- () -> list<number[]>";
        String actual = ops.help("test.listArrayDescriptor");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFallbackDescriptions() {
        String expected = "test.fooDescriptor:\n\t- () -> Foo";
        String actual = ops.help("test.fooDescriptor");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static class Foo {
    }
}

