/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.engine.matcher.convert;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.engine.AbstractTestEnvironment;
import org.scijava.ops.engine.adapt.functional.ComputersToFunctionsViaFunction;
import org.scijava.ops.engine.copy.CopyOpCollection;
import org.scijava.ops.engine.create.CreateOpCollection;
import org.scijava.ops.engine.matcher.convert.IdentityCollection;
import org.scijava.ops.engine.matcher.convert.PrimitiveArrayConverters;
import org.scijava.ops.engine.matcher.convert.PrimitiveConverters;
import org.scijava.ops.engine.matcher.convert.UtilityConverters;
import org.scijava.ops.spi.OpCollection;
import org.scijava.ops.spi.OpField;

public class ConversionAdaptationTest
extends AbstractTestEnvironment
implements OpCollection {
    @OpField(names="test.math.modulus")
    public final Computers.Arity2<Integer[], Integer, Integer[]> modOp = (inArr, mod, outArr) -> {
        for (int i = 0; i < ((Integer[])inArr).length && i < ((Integer[])outArr).length; ++i) {
            outArr[i] = inArr[i] % mod;
        }
    };

    @BeforeAll
    public static void AddNeededOps() {
        ops.register(new Object[]{new ConversionAdaptationTest()});
        ops.register(new Object[]{new CopyOpCollection()});
        ops.register(new Object[]{new CreateOpCollection()});
        ops.register(new Object[]{new IdentityCollection()});
        ops.register(new Object[]{new PrimitiveConverters()});
        ops.register(new Object[]{new PrimitiveArrayConverters()});
        ops.register(new Object[]{new UtilityConverters()});
        Object[] adapters = ConversionAdaptationTest.objsFromNoArgConstructors(ComputersToFunctionsViaFunction.class.getDeclaredClasses());
        ops.register(adapters);
    }

    @Test
    public void testAdaptAndConvert() {
        Double[] inArr = new Double[]{1.0, 4.0, 6.0};
        Double modulus = 3.0;
        Object[] expected = new Double[]{1.0, 1.0, 0.0};
        Object[] actual = (Double[])ops.op("test.math.modulus").input((Object)inArr, (Object)modulus).outType(Double[].class).apply();
        Assertions.assertArrayEquals((Object[])expected, (Object[])actual);
    }
}

