/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.copy;

import net.imglib2.Cursor;
import net.imglib2.FinalDimensions;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.integer.IntType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class CopyImgLabelingTest<T extends Type<T>, L extends Type<L>, I extends IntegerType<I>>
extends AbstractOpTest {
    private ImgLabeling<String, IntType> input;
    private ImgLabeling<String, IntType> copy;

    @BeforeEach
    public void createData() {
        this.input = (ImgLabeling)ops.op("create.imgLabeling").input((Object)new FinalDimensions(new int[]{10, 10}), (Object)new IntType()).outType((Nil)new Nil<ImgLabeling<String, IntType>>(){}).apply();
        this.copy = (ImgLabeling)ops.op("create.imgLabeling").input((Object)new FinalDimensions(new int[]{10, 10}), (Object)new IntType()).outType((Nil)new Nil<ImgLabeling<String, IntType>>(){}).apply();
        Cursor inc = this.input.cursor();
        while (inc.hasNext()) {
            ((LabelingType)inc.next()).add((Object)(Math.random() > 0.5 ? "A" : "B"));
        }
        while (inc.hasNext()) {
            ((LabelingType)inc.next()).add((Object)(Math.random() > 0.5 ? "A" : "B"));
        }
    }

    @Test
    public void testCopyImgLabeling() {
        ops.op("copy.imgLabeling").input(this.input).output(this.copy).compute();
        Assertions.assertNotNull(this.copy);
        Cursor inCursor = this.input.cursor();
        for (LabelingType type : this.copy) {
            Assertions.assertEquals((Object)inCursor.next(), (Object)type);
        }
    }
}

