/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.create;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.complex.ComplexDoubleType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class CreateKernel2ndDerivBiGaussTest
extends AbstractOpTest {
    @Test
    public void testKernel2ndDerivBiGauss() {
        double sigma = 3.0;
        double[] sigmas = new double[]{3.0, 1.5};
        RandomAccessibleInterval kernelD = (RandomAccessibleInterval)ops.op("create.kernel2ndDerivBiGauss").input((Object)sigmas, (Object)2, (Object)new DoubleType()).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        Assertions.assertEquals((long)19L, (long)kernelD.dimension(0));
        Assertions.assertEquals((long)19L, (long)kernelD.dimension(1));
        long[] position = new long[]{kernelD.dimension(0) / 2L, kernelD.dimension(1) / 2L};
        RandomAccess samplerD = kernelD.randomAccess();
        samplerD.setPosition(position);
        Assertions.assertEquals((double)-0.01477, (double)((DoubleType)samplerD.get()).getRealDouble(), (double)5.0E-5);
        double[] values = new double[5];
        values[0] = ((DoubleType)samplerD.get()).getRealDouble();
        samplerD.move(1, 0);
        values[1] = ((DoubleType)samplerD.get()).getRealDouble();
        samplerD.move(-2, 0);
        values[2] = ((DoubleType)samplerD.get()).getRealDouble();
        samplerD.move(1, 0);
        samplerD.move(1, 1);
        values[3] = ((DoubleType)samplerD.get()).getRealDouble();
        samplerD.move(-2, 1);
        values[4] = ((DoubleType)samplerD.get()).getRealDouble();
        Assertions.assertEquals((double)1.0, (double)(values[1] - values[0]), (double)0.999);
        Assertions.assertEquals((double)1.0, (double)(values[2] - values[0]), (double)0.999);
        Assertions.assertEquals((double)1.0, (double)(values[3] - values[0]), (double)0.999);
        Assertions.assertEquals((double)1.0, (double)(values[4] - values[0]), (double)0.999);
        int wasCaught = 0;
        try {
            double[] shortSigmas = new double[]{6.0};
            kernelD = (RandomAccessibleInterval)ops.op("create.kernel2ndDerivBiGauss").input((Object)shortSigmas, (Object)2, (Object)new DoubleType()).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        }
        catch (IllegalArgumentException e) {
            ++wasCaught;
        }
        try {
            double[] negativeSigmas = new double[]{-1.0, 0.0};
            kernelD = (RandomAccessibleInterval)ops.op("create.kernel2ndDerivBiGauss").input((Object)negativeSigmas, (Object)2, (Object)new DoubleType()).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        }
        catch (IllegalArgumentException e) {
            ++wasCaught;
        }
        try {
            kernelD = (RandomAccessibleInterval)ops.op("create.kernel2ndDerivBiGauss").input((Object)sigmas, (Object)0, (Object)new DoubleType()).outType((Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}).apply();
        }
        catch (IllegalArgumentException e) {
            ++wasCaught;
        }
        Assertions.assertEquals((int)3, (int)wasCaught);
        RandomAccessibleInterval kernelCD = (RandomAccessibleInterval)ops.op("create.kernel2ndDerivBiGauss").input((Object)sigmas, (Object)2, (Object)new ComplexDoubleType()).outType((Nil)new Nil<RandomAccessibleInterval<ComplexDoubleType>>(){}).apply();
        RandomAccess samplerCD = kernelCD.randomAccess();
        samplerCD.setPosition(position);
        Assertions.assertEquals((double)0.0, (double)((ComplexDoubleType)samplerCD.get()).getImaginaryDouble(), (double)1.0E-5);
        kernelCD = (RandomAccessibleInterval)ops.op("create.kernel2ndDerivBiGauss").input((Object)sigmas, (Object)3, (Object)new ComplexDoubleType()).outType((Nil)new Nil<RandomAccessibleInterval<ComplexDoubleType>>(){}).apply();
    }
}

