/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.describe;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.common3.Types;
import org.scijava.ops.api.OpInfo;
import org.scijava.ops.image.AbstractOpTest;

public class ImgLib2DescriptorsTest
extends AbstractOpTest {
    public static <T extends RealType<T>> void realType(T in) {
        in.mul(in);
    }

    @Test
    public void testRealTypeDescription() {
        String expected = "test.describeRealType:\n\t- (@MUTABLE number) -> None";
        String actual = ops.help("test.describeRealType");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static <T extends ComplexType<T>> void complexType(T in) {
        in.mul(in);
    }

    @Test
    public void testComplexTypeDescription() {
        String expected = "test.describeComplexType:\n\t- (@MUTABLE complex-number) -> None";
        String actual = ops.help("test.describeComplexType");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static <T extends RealType<T>> void randomAccessibleInterval(RandomAccessibleInterval<T> in) {
        LoopBuilder.setImages(in).forEachPixel(i -> i.mul(i));
    }

    @Test
    public void testRAIDescription() {
        String expected = "test.RAImutator:\n\t- (@MUTABLE image) -> None";
        String actual = ops.help("test.RAImutator");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static <T extends RealType<T>> void iterableInterval(IterableInterval<T> in) {
        Cursor c = in.cursor();
        while (c.hasNext()) {
            RealType i = (RealType)c.next();
            i.mul((Object)i);
        }
    }

    @Test
    public void testIIDescription() {
        String expected = "test.IIMutator:\n\t- (@MUTABLE image) -> None";
        String actual = ops.help("test.IIMutator");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static <T, I extends IntegerType<I>> void imgLabeling(ImgLabeling<T, I> in) {
    }

    @Test
    public void testImgLabelingDescription() {
        String expected = "test.ImgLabelingMutator:\n\t- (@MUTABLE labeling) -> None";
        String actual = ops.help("test.ImgLabelingMutator");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    public static <T extends NativeType<T>, A extends DataAccess> void arrayImg(ArrayImg<T, A> in) {
    }

    @Test
    public void testArrayImgDescription() {
        for (OpInfo info : ops.infos("engine.describe")) {
            Type in = (Type)info.inputTypes().get(0);
            Assertions.assertInstanceOf(ParameterizedType.class, (Object)in);
            Type descriptorType = ((ParameterizedType)in).getActualTypeArguments()[0];
            Assertions.assertFalse((boolean)Types.isAssignable((Type)descriptorType, ArrayImg.class));
        }
        String expected = "test.ArrayImgMutator:\n\t- (@MUTABLE image) -> None";
        String actual = ops.help("test.ArrayImgMutator");
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

