/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.filter.derivativeGauss;

import net.imglib2.Cursor;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class DefaultDerivativeGaussTest
extends AbstractOpTest {
    double[] regressionRowValues = new double[]{0.0, 0.0, 0.0, 2.1876502452391353, 117.25400606437196, 0.0, -117.25400606437196, -2.1876502452391353, 0.0, 0.0};

    @Test
    public void testImgParamDimensionsMismatch() {
        ArrayImg<FloatType, FloatArray> input = TestImgGeneration.floatArray(false, 30L, 30L, 30L);
        Img output = (Img)ops.op("create.img").input(input).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        int[] derivatives = new int[]{1, 0};
        double[] sigmas = new double[]{1.0, 1.0};
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ops.op("filter.derivativeGauss").input((Object)input, (Object)sigmas, (Object)derivatives).output((Object)output).compute());
        Assertions.assertTrue((boolean)e.getMessage().equalsIgnoreCase("derivatives array must include values for each dimension!"));
    }

    @Test
    public void testDerivativeGauss() {
        int width = 10;
        Img input = (Img)ops.op("create.img").input((Object)new FinalDimensions(new int[]{10, 10}), (Object)new DoubleType()).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        Img output = (Img)ops.op("create.img").input((Object)input, (Object)new DoubleType()).outType((Nil)new Nil<Img<DoubleType>>(){}).apply();
        RandomAccess inputRA = input.randomAccess();
        inputRA.setPosition(5, 0);
        for (int i = 0; i < 10; ++i) {
            inputRA.setPosition(i, 1);
            ((DoubleType)inputRA.get()).set(255.0);
        }
        int[] derivatives = new int[]{1, 0};
        double[] sigmas = new double[]{0.5, 0.5};
        ops.op("filter.derivativeGauss").input((Object)input, (Object)sigmas, (Object)derivatives).output((Object)output).compute();
        Cursor cursor = output.localizingCursor();
        int currentPixel = 0;
        while (cursor.hasNext()) {
            cursor.fwd();
            Assertions.assertEquals((double)((DoubleType)cursor.get()).getRealDouble(), (double)this.regressionRowValues[currentPixel % 10], (double)0.0);
            ++currentPixel;
        }
    }
}

