/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.linalg.rotate;

import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class Rotate3fTest
extends AbstractOpTest {
    private static final Quaternionfc IDENTITY = new Quaternionf(1.0f, 0.0f, 0.0f, 0.0f);

    @Test
    public void testAxisAngle() {
        Vector3f xAxis = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f in = new Vector3f((Vector3fc)xAxis);
        AxisAngle4f axisAngle = new AxisAngle4f(1.5707964f, 0.0f, 0.0f, 1.0f);
        Vector3f expected = xAxis.rotate((Quaternionfc)new Quaternionf(axisAngle));
        Vector3f result = (Vector3f)ops.op("linalg.rotate").input((Object)in, (Object)axisAngle).outType(Vector3f.class).apply();
        Assertions.assertEquals((Object)expected, (Object)result, (String)"Rotation is incorrect");
    }

    @Test
    public void testCalculate() {
        Vector3f xAxis = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f in = new Vector3f((Vector3fc)xAxis);
        Vector3f result = (Vector3f)ops.op("linalg.rotate").input((Object)in, (Object)IDENTITY).outType(Vector3f.class).apply();
        Assertions.assertNotSame((Object)in, (Object)result, (String)"Op should create a new object for output");
        Assertions.assertEquals((Object)xAxis, (Object)result, (String)"Rotation is incorrect");
    }
}

