/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.logic;

import net.imglib2.type.logic.BitType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class BooleanTypeLogicTest
extends AbstractOpTest {
    @Test
    public void testAnd() {
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.and").input((Object)new BitType(true), (Object)new BitType(true)).outType(BitType.class).apply()).get());
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.and").input((Object)new BitType(true), (Object)new BitType(false)).outType(BitType.class).apply()).get());
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.and").input((Object)new BitType(false), (Object)new BitType(true)).outType(BitType.class).apply()).get());
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.and").input((Object)new BitType(false), (Object)new BitType(false)).outType(BitType.class).apply()).get());
    }

    @Test
    public void testComparableGreaterThan() {
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.greaterThan").input((Object)5.0, (Object)3.0).outType(BitType.class).apply()).get());
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.greaterThan").input((Object)5.0, (Object)6.0).outType(BitType.class).apply()).get());
    }

    @Test
    public void testComparableGreaterThanOrEqual() {
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.greaterThanOrEqual").input((Object)5.0, (Object)3.0).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.greaterThanOrEqual").input((Object)5.0, (Object)5.0).outType(BitType.class).apply()).get());
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.greaterThanOrEqual").input((Object)5.0, (Object)6.0).outType(BitType.class).apply()).get());
    }

    @Test
    public void testComparableLessThan() {
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.lessThan").input((Object)5.0, (Object)3.0).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.lessThan").input((Object)5.0, (Object)6.0).outType(BitType.class).apply()).get());
    }

    @Test
    public void testComparableLessThanOrEqual() {
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.lessThanOrEqual").input((Object)5.0, (Object)3.0).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.lessThanOrEqual").input((Object)5.0, (Object)6.0).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.lessThanOrEqual").input((Object)5.0, (Object)5.0).outType(BitType.class).apply()).get());
    }

    @Test
    public void testObjectsEqual() {
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.equal").input((Object)2, (Object)1).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.equal").input((Object)2, (Object)2).outType(BitType.class).apply()).get());
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.equal").input((Object)2, (Object)3).outType(BitType.class).apply()).get());
    }

    @Test
    public void testObjectsNotEqual() {
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.notEqual").input((Object)2, (Object)1).outType(BitType.class).apply()).get());
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.notEqual").input((Object)2, (Object)2).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.notEqual").input((Object)2, (Object)3).outType(BitType.class).apply()).get());
    }

    @Test
    public void testNot() {
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.not").input((Object)new BitType(true)).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.not").input((Object)new BitType(false)).outType(BitType.class).apply()).get());
    }

    @Test
    public void testOr() {
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.or").input((Object)new BitType(true), (Object)new BitType(true)).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.or").input((Object)new BitType(true), (Object)new BitType(false)).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.or").input((Object)new BitType(false), (Object)new BitType(true)).outType(BitType.class).apply()).get());
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.or").input((Object)new BitType(false), (Object)new BitType(false)).outType(BitType.class).apply()).get());
    }

    @Test
    public void testXor() {
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.xor").input((Object)new BitType(true), (Object)new BitType(true)).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.xor").input((Object)new BitType(true), (Object)new BitType(false)).outType(BitType.class).apply()).get());
        Assertions.assertTrue((boolean)((BitType)ops.op("logic.xor").input((Object)new BitType(false), (Object)new BitType(true)).outType(BitType.class).apply()).get());
        Assertions.assertFalse((boolean)((BitType)ops.op("logic.xor").input((Object)new BitType(false), (Object)new BitType(false)).outType(BitType.class).apply()).get());
    }
}

