/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.math;

import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.IntType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;

public class BinaryNumericTypeMathTest
extends AbstractOpTest {
    private static final IntType A = new IntType(12);
    private static final IntType B = new IntType(7);
    private static String[] methods = new String[]{"function", "computer"};

    @Test
    public void testAdd() {
        IntType e = A.copy();
        e.add((GenericIntType)B);
        this.test("math.add", e.get());
    }

    @Test
    public void testSub() {
        IntType e = A.copy();
        e.sub((GenericIntType)B);
        this.test("math.sub", e.get());
    }

    @Test
    public void testDiv() {
        IntType e = A.copy();
        e.div((GenericIntType)B);
        this.test("math.div", e.get());
    }

    @Test
    public void testMul() {
        IntType e = A.copy();
        e.mul((GenericIntType)B);
        this.test("math.mul", e.get());
    }

    @Test
    public void testPow() {
        IntType e = A.copy();
        e.pow((GenericIntType)B);
        this.test("math.pow", e.get());
    }

    private void test(String opNames, int expectedValue) {
        for (String opName : opNames.split(", ")) {
            for (String m : methods) {
                IntType c = new IntType();
                if (m.equals("function")) {
                    c = (IntType)ops.op(opName).input((Object)A, (Object)B).outType(IntType.class).apply();
                } else if (m.equals("computer")) {
                    ops.op(opName).input((Object)A, (Object)B).output((Object)c).compute();
                }
                Assertions.assertEquals((int)expectedValue, (int)c.get());
            }
        }
    }
}

