/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.math;

import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.type.numeric.integer.IntType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Computers;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;
import org.scijava.types.Nil;

public class ImageBinaryMathTest
extends AbstractOpTest {
    private static final IntType I = new IntType(25);

    @Test
    public void testAddImageC() {
        ArrayImg<IntType, IntArray> imgA = TestImgGeneration.intArray(true, 10L, 10L);
        ArrayImg<IntType, IntArray> imgB = TestImgGeneration.intArray(true, 10L, 10L);
        ArrayImg<IntType, IntArray> imgC = TestImgGeneration.intArray(true, 10L, 10L);
        int originalVal = ((IntType)imgA.cursor().next()).get() + ((IntType)imgB.cursor().next()).get();
        ops.op("math.add").input(imgA, imgB).output(imgC).compute();
        Assertions.assertEquals((int)originalVal, (int)((IntType)imgC.cursor().next()).get());
    }

    @Test
    public void testAddImageF() {
        ArrayImg<IntType, IntArray> imgA = TestImgGeneration.intArray(true, 10L, 10L);
        ArrayImg<IntType, IntArray> imgB = TestImgGeneration.intArray(true, 10L, 10L);
        int originalVal = ((IntType)imgA.cursor().next()).get() + ((IntType)imgB.cursor().next()).get();
        Nil<Img<IntType>> outType = new Nil<Img<IntType>>(){};
        Img imgC = (Img)ops.op("math.add").input(imgA, imgB).outType((Nil)outType).apply();
        Assertions.assertEquals((int)originalVal, (int)((IntType)imgC.cursor().next()).get());
    }

    @Test
    public void testSubImageFNoOutType() {
        ArrayImg<IntType, IntArray> imgA = TestImgGeneration.intArray(true, 10L, 10L);
        int originalVal = ((IntType)imgA.cursor().next()).get();
        Img imgC = (Img)ops.op("math.sub").input(imgA, (Object)new IntType(25)).apply();
        Assertions.assertEquals((int)(originalVal - 25), (int)((IntType)imgC.cursor().next()).get());
    }

    @Test
    public void testAddRAIRealTypeC() {
        ArrayImg<IntType, IntArray> imgIntType = TestImgGeneration.intArray(true, 10L, 10L);
        int originalVal = ((IntType)imgIntType.cursor().next()).get();
        Nil<RandomAccessibleInterval<IntType>> inType = new Nil<RandomAccessibleInterval<IntType>>(){};
        Nil<RandomAccessibleInterval<IntType>> outType = new Nil<RandomAccessibleInterval<IntType>>(){};
        Computers.Arity2 computer = ops.op("math.add").inType((Nil)inType, Nil.of(IntType.class)).outType((Nil)outType).computer();
        ArrayImg<IntType, IntArray> result = TestImgGeneration.intArray(true, 10L, 10L);
        computer.compute(imgIntType, (Object)I, result);
        Assertions.assertEquals((int)(originalVal + I.get()), (int)((IntType)result.getAt(new int[]{0, 0})).get());
    }

    @Test
    public void testAddRealTypeF() {
        ArrayImg<IntType, IntArray> imgIntType = TestImgGeneration.intArray(true, 10L, 10L);
        int originalVal = ((IntType)imgIntType.cursor().next()).get();
        Nil<Img<IntType>> outType = new Nil<Img<IntType>>(){};
        Img result = (Img)ops.op("math.add").input(imgIntType, (Object)I).outType((Nil)outType).apply();
        this.validateResult((Img<IntType>)result, originalVal);
    }

    @Test
    public void testAddRealTypeC() {
        ArrayImg<IntType, IntArray> imgIntType = TestImgGeneration.intArray(true, 10L, 10L);
        int originalVal = ((IntType)imgIntType.cursor().next()).get();
        ArrayImg<IntType, IntArray> out = TestImgGeneration.intArray(false, 10L, 10L);
        ops.op("math.add").input(imgIntType, (Object)I).output(out).compute();
        this.validateResult((Img<IntType>)out, originalVal);
    }

    private void validateResult(Img<IntType> result, int originalVal) {
        Assertions.assertEquals((int)((IntType)result.cursor().next()).get(), (int)(originalVal + I.get()));
    }
}

