/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.morphology;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.neighborhood.DiamondShape;
import net.imglib2.algorithm.neighborhood.RectangleShape;
import net.imglib2.img.Img;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.real.FloatType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class MorphologyOpsTest
extends AbstractOpTest {
    private Img<BitType> imgWithoutHoles;
    private Img<BitType> imgWithHoles;
    private Img<BitType> invertedImgWithFilledHoles;
    private boolean initialized = false;

    @BeforeEach
    public void loadImages() {
        if (this.initialized) {
            return;
        }
        Img<FloatType> inputWithoutHoles = this.openFloatImg("img_without_holes.png");
        Img<FloatType> inputWithHoles = this.openFloatImg("img_with_holes.png");
        Img<FloatType> invertedInputWithFilledHoles = this.openFloatImg("inverted_img_with_filled_holes.png");
        Cursor inputWithoutHolesCursor = inputWithoutHoles.cursor();
        Cursor inputWithHolesCursor = inputWithHoles.cursor();
        Cursor invertedInputWithFilledHolesCursor = invertedInputWithFilledHoles.cursor();
        this.imgWithoutHoles = (Img)ops.op("create.img").input(inputWithoutHoles, (Object)new BitType()).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        this.imgWithHoles = (Img)ops.op("create.img").input(inputWithHoles, (Object)new BitType()).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        this.invertedImgWithFilledHoles = (Img)ops.op("create.img").input(invertedInputWithFilledHoles, (Object)new BitType()).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Cursor imgWithoutHolesCursor = this.imgWithoutHoles.cursor();
        Cursor imgWithHolesCursor = this.imgWithHoles.cursor();
        Cursor invertedImgWithFilledHolesCursor = this.invertedImgWithFilledHoles.cursor();
        while (inputWithoutHolesCursor.hasNext()) {
            ((BitType)imgWithoutHolesCursor.next()).set(((FloatType)inputWithoutHolesCursor.next()).get() > 0.0f);
        }
        while (inputWithHolesCursor.hasNext()) {
            ((BitType)imgWithHolesCursor.next()).set(((FloatType)inputWithHolesCursor.next()).get() > 0.0f);
        }
        while (invertedInputWithFilledHolesCursor.hasNext()) {
            ((BitType)invertedImgWithFilledHolesCursor.next()).set(((FloatType)invertedInputWithFilledHolesCursor.next()).get() > 0.0f);
        }
        this.initialized = true;
    }

    @Test
    public void testExtractHoles() {
        Assertions.assertNotNull((Object)ops.op("morphology.extractHoles").input(this.imgWithoutHoles, (Object)new DiamondShape(1L)).outType((Nil)new Nil<Img<BitType>>(){}).apply(), (String)"Img Without Holes");
        Assertions.assertNotNull((Object)ops.op("morphology.extractHoles").input(this.imgWithHoles, (Object)new DiamondShape(1L)).outType((Nil)new Nil<Img<BitType>>(){}).apply(), (String)"Img With Holes");
    }

    @Test
    public void testFillHoles() {
        Img result = (Img)ops.op("create.img").input(this.imgWithHoles).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        ops.op("morphology.fillHoles").input(this.imgWithHoles, (Object)new DiamondShape(1L)).output((Object)result).compute();
        Cursor resultC = result.cursor();
        BitType one = new BitType(true);
        while (resultC.hasNext()) {
            Assertions.assertEquals((Object)one, (Object)resultC.next());
        }
    }

    @Test
    public void testFillHoles1() {
        Img result = (Img)ops.op("create.img").input(this.invertedImgWithFilledHoles).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        Img inverted = (Img)ops.op("create.img").input(this.invertedImgWithFilledHoles).outType((Nil)new Nil<Img<BitType>>(){}).apply();
        ops.op("image.invert").input(this.imgWithHoles).output((Object)inverted).compute();
        ops.op("morphology.fillHoles").input((Object)inverted, (Object)new DiamondShape(1L)).output((Object)result).compute();
        Cursor resultC = result.localizingCursor();
        RandomAccess groundTruthRA = this.invertedImgWithFilledHoles.randomAccess();
        while (resultC.hasNext()) {
            boolean r = ((BitType)resultC.next()).get();
            groundTruthRA.setPosition((Localizable)resultC);
            Assertions.assertEquals((Object)((BitType)groundTruthRA.get()).get(), (Object)r);
        }
    }

    @Test
    public void testFillHoles2() {
        RandomAccessibleInterval result = (RandomAccessibleInterval)ops.op("morphology.fillHoles").input(this.imgWithoutHoles, (Object)new RectangleShape(1, false)).outType((Nil)new Nil<RandomAccessibleInterval<BitType>>(){}).apply();
        Cursor groundTruthC = this.imgWithoutHoles.localizingCursor();
        RandomAccess resultRA = result.randomAccess();
        while (groundTruthC.hasNext()) {
            boolean r = ((BitType)groundTruthC.next()).get();
            resultRA.setPosition((Localizable)groundTruthC);
            Assertions.assertEquals((Object)r, (Object)((BitType)resultRA.get()).get());
        }
    }
}

