/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.stats;

import java.util.ArrayList;
import java.util.Collections;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.ops.image.util.TestImgGeneration;

public class DefaultMedianTest
extends AbstractOpTest {
    @Test
    public void testOneElement() {
        ArrayList<DoubleType> numbers = new ArrayList<DoubleType>();
        numbers.add(new DoubleType(1.0));
        DoubleType result = new DoubleType();
        ops.op("stats.median").input(numbers).output((Object)result).compute();
        Assertions.assertEquals((double)((RealType)numbers.get(0)).getRealDouble(), (double)result.getRealDouble(), (double)1.0E-12);
    }

    @Test
    public void testOddN() {
        ArrayList<DoubleType> numbers = new ArrayList<DoubleType>();
        numbers.add(new DoubleType(1.0));
        numbers.add(new DoubleType(2.0));
        numbers.add(new DoubleType(3.0));
        numbers.add(new DoubleType(4.0));
        numbers.add(new DoubleType(5.0));
        Collections.shuffle(numbers);
        DoubleType result = new DoubleType();
        ops.op("stats.median").input(numbers).output((Object)result).compute();
        Assertions.assertEquals((double)3.0, (double)result.getRealDouble(), (double)1.0E-12);
    }

    @Test
    public void testEvenN() {
        ArrayList<DoubleType> numbers = new ArrayList<DoubleType>();
        numbers.add(new DoubleType(1.0));
        numbers.add(new DoubleType(2.0));
        numbers.add(new DoubleType(3.0));
        numbers.add(new DoubleType(4.0));
        Collections.shuffle(numbers);
        DoubleType result = new DoubleType();
        ops.op("stats.median").input(numbers).output((Object)result).compute();
        Assertions.assertEquals((double)2.5, (double)result.getRealDouble(), (double)1.0E-12);
    }

    @Test
    public void testRandomImg() {
        Img<UnsignedByteType> randomlyFilledImg = TestImgGeneration.randomlyFilledUnsignedByteWithSeed(new long[]{100L, 100L}, 1234567890L);
        DoubleType result = new DoubleType();
        ops.op("stats.median").input(randomlyFilledImg).output((Object)result).compute();
        Assertions.assertEquals((double)128.0, (double)result.getRealDouble(), (double)1.0E-5);
    }
}

