/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.concatenateView;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.operators.ValueEquals;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.StackView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class ConcatenateViewTest
extends AbstractOpTest {
    private static final long SEED = 305419896L;
    private final long[] dim = new long[]{3L, 4L, 5L, 6L};
    private final long divider = 3L;
    private final int axis = 3;
    final long numElements = Intervals.numElements((long[])this.dim);
    final MersenneTwisterFast rng = new MersenneTwisterFast(305419896L);
    final byte[] data = new byte[(int)this.numElements];
    final ArrayImg<ByteType, ByteArray> img = ArrayImgs.bytes((byte[])this.data, (long[])this.dim);

    @BeforeEach
    public void fillData() {
        this.rng.nextBytes(this.data);
    }

    private <T> List<RandomAccessibleInterval<T>> createIntervals(RandomAccessibleInterval<T> source, long divider, int axis) {
        long[] min = Intervals.minAsLongArray(source);
        long[] max = Intervals.maxAsLongArray(source);
        long[] min1 = (long[])min.clone();
        long[] min2 = (long[])min.clone();
        long[] max1 = (long[])max.clone();
        long[] max2 = (long[])max.clone();
        max1[axis] = divider;
        min2[axis] = divider + 1L;
        IntervalView interval1 = Views.interval(source, (long[])min1, (long[])max1);
        IntervalView interval2 = Views.interval(source, (long[])min2, (long[])max2);
        return Arrays.asList(interval1, interval2);
    }

    private static <T extends ValueEquals<T>> void testEqual(RandomAccessibleInterval<T> rai1, RandomAccessibleInterval<T> rai2) {
        Assertions.assertArrayEquals((long[])Intervals.minAsLongArray(rai1), (long[])Intervals.minAsLongArray(rai2));
        Assertions.assertArrayEquals((long[])Intervals.maxAsLongArray(rai1), (long[])Intervals.maxAsLongArray(rai2));
        for (Pair p : Views.interval((RandomAccessible)Views.pair(rai1, rai2), rai1)) {
            Assertions.assertTrue((boolean)((ValueEquals)p.getA()).valueEquals((Object)((ValueEquals)p.getB())));
        }
    }

    @Test
    public void testDefaultConcatenate() {
        BiFunction concatFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.concatenateView", (Nil)new Nil<Integer>(){}, (Nil)new Nil<List<RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){});
        List intervals = this.createIntervals((RandomAccessibleInterval)this.img, 3L, 3);
        RandomAccessibleInterval cat1 = Views.concatenate((int)3, intervals);
        RandomAccessibleInterval cat2 = (RandomAccessibleInterval)concatFunc.apply(3, intervals);
        ConcatenateViewTest.testEqual(cat1, cat2);
    }

    @Test
    public void testConcatenateWithAccessMode() {
        Functions.Arity3 concatFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.concatenateView", (Nil)new Nil<Integer>(){}, (Nil)new Nil<StackView.StackAccessMode>(){}, (Nil)new Nil<List<RandomAccessibleInterval<ByteType>>>(){}, (Nil)new Nil<RandomAccessibleInterval<ByteType>>(){});
        List intervals = this.createIntervals((RandomAccessibleInterval)this.img, 3L, 3);
        for (StackView.StackAccessMode mode : StackView.StackAccessMode.values()) {
            RandomAccessibleInterval cat1 = Views.concatenate((int)3, (StackView.StackAccessMode)mode, intervals);
            RandomAccessibleInterval cat2 = (RandomAccessibleInterval)concatFunc.apply((Object)3, (Object)mode, intervals);
            ConcatenateViewTest.testEqual(cat1, cat2);
        }
    }
}

