/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.offsetView;

import java.util.function.BiFunction;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class OffsetViewTest
extends AbstractOpTest {
    @Test
    public void testDefaultOffset() {
        BiFunction offsetFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.offsetView", (Nil)new Nil<RandomAccessible<DoubleType>>(){}, (Nil)new Nil<long[]>(){}, (Nil)new Nil<MixedTransformView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MixedTransformView il2 = Views.offset((RandomAccessible)img, (long[])new long[]{2L, 2L});
        MixedTransformView opr = (MixedTransformView)offsetFunc.apply(img, new long[]{2L, 2L});
        for (int i = 0; i < il2.getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < il2.getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)il2.getTransformToSource().getMatrix()[i][j], (double)opr.getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
    }

    @Test
    public void testDefaultOffsetInterval() {
        BiFunction offsetFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.offsetView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<Interval>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        IntervalView il2 = Views.offsetInterval((RandomAccessible)img, (Interval)new FinalInterval(new long[]{2L, 2L}, new long[]{9L, 9L}));
        IntervalView opr = (IntervalView)offsetFunc.apply(img, new FinalInterval(new long[]{2L, 2L}, new long[]{9L, 9L}));
        Assertions.assertEquals((double)il2.realMax(0), (double)opr.realMax(0), (double)1.0E-10);
        Assertions.assertEquals((double)il2.realMin(0), (double)opr.realMin(0), (double)1.0E-10);
        Assertions.assertEquals((double)il2.realMax(1), (double)opr.realMax(1), (double)1.0E-10);
        Assertions.assertEquals((double)il2.realMin(1), (double)opr.realMin(1), (double)1.0E-10);
    }

    @Test
    public void testDefaultOffsetStartEnd() {
        Functions.Arity3 offsetFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.offsetView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<long[]>(){}, (Nil)new Nil<long[]>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        IntervalView il2 = Views.offsetInterval((RandomAccessible)img, (long[])new long[]{2L, 2L}, (long[])new long[]{9L, 9L});
        IntervalView opr = (IntervalView)offsetFunc.apply((Object)img, (Object)new long[]{2L, 2L}, (Object)new long[]{9L, 9L});
        Assertions.assertEquals((double)il2.realMax(0), (double)opr.realMax(0), (double)1.0E-10);
        Assertions.assertEquals((double)il2.realMin(0), (double)opr.realMin(0), (double)1.0E-10);
        Assertions.assertEquals((double)il2.realMax(1), (double)opr.realMax(1), (double)1.0E-10);
        Assertions.assertEquals((double)il2.realMin(1), (double)opr.realMin(1), (double)1.0E-10);
    }
}

