/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.permuteView;

import java.util.function.BiFunction;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;
import org.scijava.util.MersenneTwisterFast;

public class PermuteViewTest
extends AbstractOpTest {
    private static final long SEED = 305419896L;

    public static <T> RandomAccessible<T> deinterval(RandomAccessibleInterval<T> input) {
        return Views.extendBorder(input);
    }

    @Test
    public void testDefaultPermute() {
        Functions.Arity3 permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteView", (Nil)new Nil<RandomAccessible<DoubleType>>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<MixedTransformView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        MixedTransformView il2 = Views.permute((RandomAccessible)img, (int)1, (int)0);
        MixedTransformView opr = (MixedTransformView)permuteFunc.apply(PermuteViewTest.deinterval(img), (Object)1, (Object)0);
        for (int i = 0; i < il2.getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < il2.getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)il2.getTransformToSource().getMatrix()[i][j], (double)opr.getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
    }

    @Test
    public void testDefaultPermuteCoordinates() {
        BiFunction permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteCoordinatesView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<int[]>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{2, 2});
        Cursor c = img.cursor();
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        while (c.hasNext()) {
            ((DoubleType)c.next()).set(r.nextDouble());
        }
        Cursor il2 = Views.permuteCoordinates((RandomAccessibleInterval)img, (int[])new int[]{0, 1}).cursor();
        RandomAccess opr = ((IntervalView)permuteFunc.apply(img, new int[]{0, 1})).randomAccess();
        while (il2.hasNext()) {
            il2.next();
            opr.setPosition((Localizable)il2);
            Assertions.assertEquals((double)((DoubleType)il2.get()).get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
        }
    }

    @Test
    public void testPermuteCoordinatesOfDimension() {
        Functions.Arity3 permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteCoordinatesView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<int[]>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{2, 2});
        Cursor c = img.cursor();
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        while (c.hasNext()) {
            ((DoubleType)c.next()).set(r.nextDouble());
        }
        Cursor il2 = Views.permuteCoordinates((RandomAccessibleInterval)img, (int[])new int[]{0, 1}, (int)1).cursor();
        RandomAccess opr = ((IntervalView)permuteFunc.apply((Object)img, (Object)new int[]{0, 1}, (Object)1)).randomAccess();
        while (il2.hasNext()) {
            il2.next();
            opr.setPosition((Localizable)il2);
            Assertions.assertEquals((double)((DoubleType)il2.get()).get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
        }
    }

    @Test
    public void testDefaultPermuteCoordinatesInverse() {
        BiFunction permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteCoordinatesInverseView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<int[]>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{2, 2});
        Cursor c = img.cursor();
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        while (c.hasNext()) {
            ((DoubleType)c.next()).set(r.nextDouble());
        }
        Cursor il2 = Views.permuteCoordinatesInverse((RandomAccessibleInterval)img, (int[])new int[]{0, 1}).cursor();
        RandomAccess opr = ((IntervalView)permuteFunc.apply(img, new int[]{0, 1})).randomAccess();
        while (il2.hasNext()) {
            il2.next();
            opr.setPosition((Localizable)il2);
            Assertions.assertEquals((double)((DoubleType)il2.get()).get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
        }
    }

    @Test
    public void testPermuteCoordinatesInverseOfDimension() {
        Functions.Arity3 permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteCoordinatesInverseView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<int[]>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{2, 2});
        Cursor c = img.cursor();
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        while (c.hasNext()) {
            ((DoubleType)c.next()).set(r.nextDouble());
        }
        IntervalView out = Views.permuteCoordinatesInverse((RandomAccessibleInterval)img, (int[])new int[]{0, 1}, (int)1);
        Cursor il2 = out.cursor();
        RandomAccess opr = ((IntervalView)permuteFunc.apply((Object)img, (Object)new int[]{0, 1}, (Object)1)).randomAccess();
        while (il2.hasNext()) {
            il2.next();
            opr.setPosition((Localizable)il2);
            Assertions.assertEquals((double)((DoubleType)il2.get()).get(), (double)((DoubleType)opr.get()).get(), (double)1.0E-10);
        }
    }

    @Test
    public void testIntervalPermute() {
        Functions.Arity3 permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{10, 10});
        IntervalView expected = Views.permute((RandomAccessibleInterval)img, (int)1, (int)0);
        IntervalView actual = (IntervalView)permuteFunc.apply((Object)img, (Object)1, (Object)0);
        for (int i = 0; i < ((MixedTransformView)expected.getSource()).getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < ((MixedTransformView)expected.getSource()).getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)((MixedTransformView)expected.getSource()).getTransformToSource().getMatrix()[i][j], (double)((MixedTransformView)actual.getSource()).getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
    }

    @Test
    public void testIntervalPermuteCoordinates() {
        BiFunction permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteCoordinatesView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<int[]>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = ArrayImgs.doubles((long[])new long[]{2L, 2L});
        Cursor c = img.cursor();
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        while (c.hasNext()) {
            ((DoubleType)c.next()).set(r.nextDouble());
        }
        IntervalView expected = Views.permuteCoordinates((RandomAccessibleInterval)img, (int[])new int[]{0, 1});
        Cursor e = expected.cursor();
        RandomAccessibleInterval actual = (RandomAccessibleInterval)permuteFunc.apply(img, new int[]{0, 1});
        RandomAccess actualRA = actual.randomAccess();
        while (e.hasNext()) {
            e.next();
            actualRA.setPosition((Localizable)e);
            Assertions.assertEquals((double)((DoubleType)e.get()).get(), (double)((DoubleType)actualRA.get()).get(), (double)1.0E-10);
        }
        Assertions.assertTrue((boolean)Intervals.equals((Interval)expected, (Interval)actual));
    }

    @Test
    public void testIntervalPermuteDimensionCoordinates() {
        Functions.Arity3 permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteCoordinatesInverseView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<int[]>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = ArrayImgs.doubles((long[])new long[]{2L, 2L});
        Cursor c = img.cursor();
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        while (c.hasNext()) {
            ((DoubleType)c.next()).set(r.nextDouble());
        }
        IntervalView expected = Views.permuteCoordinates((RandomAccessibleInterval)img, (int[])new int[]{0, 1}, (int)1);
        Cursor e = expected.cursor();
        RandomAccessibleInterval actual = (RandomAccessibleInterval)permuteFunc.apply((Object)img, (Object)new int[]{0, 1}, (Object)1);
        RandomAccess actualRA = actual.randomAccess();
        while (e.hasNext()) {
            e.next();
            actualRA.setPosition((Localizable)e);
            Assertions.assertEquals((double)((DoubleType)e.get()).get(), (double)((DoubleType)actualRA.get()).get(), (double)1.0E-10);
        }
        Assertions.assertTrue((boolean)Intervals.equals((Interval)expected, (Interval)actual));
    }

    @Test
    public void testIntervalPermuteInverseCoordinates() {
        BiFunction permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteCoordinatesInverseView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<int[]>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = ArrayImgs.doubles((long[])new long[]{2L, 2L});
        Cursor c = img.cursor();
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        while (c.hasNext()) {
            ((DoubleType)c.next()).set(r.nextDouble());
        }
        IntervalView expected = Views.permuteCoordinatesInverse((RandomAccessibleInterval)img, (int[])new int[]{0, 1});
        Cursor e = expected.cursor();
        RandomAccessibleInterval actual = (RandomAccessibleInterval)permuteFunc.apply(img, new int[]{0, 1});
        RandomAccess actualRA = actual.randomAccess();
        while (e.hasNext()) {
            e.next();
            actualRA.setPosition((Localizable)e);
            Assertions.assertEquals((double)((DoubleType)e.get()).get(), (double)((DoubleType)actualRA.get()).get(), (double)1.0E-10);
        }
        Assertions.assertTrue((boolean)Intervals.equals((Interval)expected, (Interval)actual));
    }

    @Test
    public void testIntervalPermuteInverseDimensionCoordinates() {
        Functions.Arity3 permuteFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.permuteCoordinatesInverseView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<int[]>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = ArrayImgs.doubles((long[])new long[]{2L, 2L});
        Cursor c = img.cursor();
        MersenneTwisterFast r = new MersenneTwisterFast(305419896L);
        while (c.hasNext()) {
            ((DoubleType)c.next()).set(r.nextDouble());
        }
        IntervalView expected = Views.permuteCoordinatesInverse((RandomAccessibleInterval)img, (int[])new int[]{0, 1}, (int)1);
        Cursor e = expected.cursor();
        RandomAccessibleInterval actual = (RandomAccessibleInterval)permuteFunc.apply((Object)img, (Object)new int[]{0, 1}, (Object)1);
        RandomAccess actualRA = actual.randomAccess();
        while (e.hasNext()) {
            e.next();
            actualRA.setPosition((Localizable)e);
            Assertions.assertEquals((double)((DoubleType)e.get()).get(), (double)((DoubleType)actualRA.get()).get(), (double)1.0E-10);
        }
        Assertions.assertTrue((boolean)Intervals.equals((Interval)expected, (Interval)actual));
    }
}

