/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ops.image.transform.rotateView;

import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.function.Functions;
import org.scijava.ops.api.OpBuilder;
import org.scijava.ops.api.OpEnvironment;
import org.scijava.ops.image.AbstractOpTest;
import org.scijava.types.Nil;

public class RotateViewTest
extends AbstractOpTest {
    public static <T> RandomAccessible<T> deinterval(RandomAccessibleInterval<T> input) {
        return Views.extendBorder(input);
    }

    @Test
    public void testDefaultRotate() {
        Functions.Arity3 rotateFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.rotateView", (Nil)new Nil<RandomAccessible<DoubleType>>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<MixedTransformView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{20, 10});
        MixedTransformView il2 = Views.rotate((RandomAccessible)img, (int)1, (int)0);
        MixedTransformView opr = (MixedTransformView)rotateFunc.apply(RotateViewTest.deinterval(img), (Object)1, (Object)0);
        for (int i = 0; i < il2.getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < il2.getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)il2.getTransformToSource().getMatrix()[i][j], (double)opr.getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
    }

    @Test
    public void testIntervalRotate() {
        Functions.Arity3 rotateFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.rotateView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = ArrayImgs.doubles((long[])new long[]{20L, 10L});
        IntervalView il2 = Views.rotate((RandomAccessibleInterval)img, (int)1, (int)0);
        IntervalView opr = (IntervalView)rotateFunc.apply((Object)img, (Object)1, (Object)0);
        for (int i = 0; i < ((MixedTransformView)il2.getSource()).getTransformToSource().getMatrix().length; ++i) {
            for (int j = 0; j < ((MixedTransformView)il2.getSource()).getTransformToSource().getMatrix()[i].length; ++j) {
                Assertions.assertEquals((double)((MixedTransformView)il2.getSource()).getTransformToSource().getMatrix()[i][j], (double)((MixedTransformView)opr.getSource()).getTransformToSource().getMatrix()[i][j], (double)1.0E-10);
            }
        }
    }

    @Test
    public void testIntervalRotateInterval() {
        Functions.Arity3 rotateFunc = OpBuilder.matchFunction((OpEnvironment)ops, (String)"transform.rotateView", (Nil)new Nil<RandomAccessibleInterval<DoubleType>>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<Integer>(){}, (Nil)new Nil<IntervalView<DoubleType>>(){});
        ArrayImg img = new ArrayImgFactory((NativeType)new DoubleType()).create(new int[]{20, 10});
        IntervalView il2 = Views.rotate((RandomAccessibleInterval)img, (int)1, (int)0);
        IntervalView opr = (IntervalView)rotateFunc.apply((Object)img, (Object)1, (Object)0);
        Assertions.assertEquals((long)img.min(1), (long)il2.min(0));
        Assertions.assertEquals((long)img.max(1), (long)il2.max(0));
        Assertions.assertEquals((long)img.min(0), (long)(-il2.max(1)));
        Assertions.assertEquals((long)img.max(0), (long)(-il2.min(1)));
        for (int i = 0; i < il2.numDimensions(); ++i) {
            Assertions.assertEquals((long)il2.max(i), (long)opr.max(i));
            Assertions.assertEquals((long)il2.min(i), (long)opr.min(i));
        }
    }
}

